

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Header Card -->
            <div class="card shadow-sm mb-4 border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <div>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-2">
                                    <li class="breadcrumb-item"><a href="<?php echo e(route('categories.index')); ?>" class="text-decoration-none">Categories</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Add New</li>
                                </ol>
                            </nav>
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-size: 20px;">
                                    <i class="fas fa-folder-plus"></i>
                                </div>
                                <div>
                                    <h1 class="h3 fw-bold mb-0">Create New Category</h1>
                                    <p class="text-muted mb-0">Add a new product category to organize your inventory</p>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <span class="badge bg-light text-dark fs-6 p-2">
                                <i class="fas fa-info-circle me-1"></i>
                                Required fields marked with *
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Form Card -->
            <div class="card shadow border-0">
                <div class="card-header bg-white py-3">
                    <h5 class="mb-0 fw-semibold">
                        <i class="fas fa-folder text-primary me-2"></i>
                        Category Information
                    </h5>
                </div>
                
                <div class="card-body p-4">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <div class="d-flex">
                                <i class="fas fa-exclamation-triangle me-3 mt-1"></i>
                                <div>
                                    <h6 class="alert-heading mb-2">Please fix the following errors:</h6>
                                    <ul class="mb-0 ps-3">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('categories.store')); ?>" id="createCategoryForm">
                        <?php echo csrf_field(); ?>

                        <div class="row">
                            <!-- Basic Information Section -->
                            <div class="col-md-12 mb-4">
                                <div class="form-section">
                                    <h6 class="section-title">
                                        <i class="fas fa-info-circle me-2"></i>Basic Information
                                    </h6>
                                    
                                    <div class="mb-4">
                                        <label for="name" class="form-label fw-semibold">
                                            Category Name <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light">
                                                <i class="fas fa-folder text-primary"></i>
                                            </span>
                                            <input type="text" 
                                                   name="name" 
                                                   id="name"
                                                   value="<?php echo e(old('name')); ?>"
                                                   class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   required
                                                   placeholder="Enter category name (e.g., Electronics, Clothing)">
                                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <small class="text-muted">Choose a unique and descriptive name for the category</small>
                                    </div>

                                    <div class="mb-3">
                                        <label for="description" class="form-label fw-semibold">
                                            Description
                                        </label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light align-items-start pt-3">
                                                <i class="fas fa-align-left text-primary"></i>
                                            </span>
                                            <textarea name="description" 
                                                      id="description"
                                                      class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                      rows="5"
                                                      placeholder="Enter category description (optional)"><?php echo e(old('description')); ?></textarea>
                                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="d-flex justify-content-between mt-1">
                                            <small class="text-muted" id="charCount">0/500 characters</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Form Actions -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center pt-4 border-top">
                                    <div>
                                        <a href="<?php echo e(route('categories.index')); ?>" 
                                           class="btn btn-outline-secondary">
                                            <i class="fas fa-arrow-left me-1"></i>Back to Categories
                                        </a>
                                    </div>
                                    <div>
                                        <button type="reset" class="btn btn-outline-danger me-2">
                                            <i class="fas fa-redo me-1"></i>Reset Form
                                        </button>
                                        <button type="submit" class="btn btn-success px-4">
                                            <i class="fas fa-save me-1"></i>Create Category
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="card-footer bg-light py-3">
                    <div class="row align-items-center">
                        <div class="col-md-12 text-center">
                            <small class="text-muted">
                                <i class="fas fa-shield-alt me-1"></i>
                                Category information will be stored securely in the database.
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Form validation
    document.getElementById('createCategoryForm').addEventListener('submit', function(e) {
        const nameField = document.getElementById('name');
        let valid = true;
        
        if (!nameField.value.trim()) {
            valid = false;
            if (!nameField.classList.contains('is-invalid')) {
                nameField.classList.add('is-invalid');
                nameField.nextElementSibling.textContent = 'Category name is required';
            }
        }
        
        if (!valid) {
            e.preventDefault();
            const alertDiv = document.createElement('div');
            alertDiv.className = 'alert alert-danger alert-dismissible fade show mt-3';
            alertDiv.innerHTML = `
                <i class="fas fa-exclamation-triangle me-2"></i>
                Please fix the errors in the form before submitting.
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            this.querySelector('.card-body').prepend(alertDiv);
            
            // Scroll to error
            nameField.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }
    });

    // Character counter for description
    const descriptionTextarea = document.getElementById('description');
    const charCount = document.getElementById('charCount');
    
    if (descriptionTextarea && charCount) {
        descriptionTextarea.addEventListener('input', function() {
            const length = this.value.length;
            charCount.textContent = `${length}/500 characters`;
            
            if (length > 500) {
                charCount.classList.remove('text-muted');
                charCount.classList.add('text-danger');
                this.classList.add('is-invalid');
            } else {
                charCount.classList.remove('text-danger');
                charCount.classList.add('text-muted');
                this.classList.remove('is-invalid');
            }
        });
        
        // Initialize count
        charCount.textContent = `${descriptionTextarea.value.length}/500 characters`;
    }

    // Remove validation styling on input
    document.querySelectorAll('input, textarea, select').forEach(field => {
        field.addEventListener('input', function() {
            if (this.classList.contains('is-invalid')) {
                this.classList.remove('is-invalid');
                const feedback = this.nextElementSibling;
                if (feedback && feedback.classList.contains('invalid-feedback')) {
                    feedback.textContent = '';
                }
            }
        });
    });

    // Form reset confirmation
    document.querySelector('button[type="reset"]').addEventListener('click', function(e) {
        if (document.getElementById('createCategoryForm').checkValidity()) {
            if (confirm('Are you sure you want to reset the form? All entered data will be lost.')) {
                return true;
            } else {
                e.preventDefault();
            }
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .avatar-circle {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }

    .form-section {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 1.5rem;
        margin-bottom: 1.5rem;
        border: 1px solid #e9ecef;
    }

    .section-title {
        color: #495057;
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 1.5rem;
        padding-bottom: 0.5rem;
        border-bottom: 2px solid #dee2e6;
    }

    .form-label {
        font-weight: 500;
        margin-bottom: 0.5rem;
        color: #495057;
    }

    .input-group-text {
        border-right: none;
        background-color: #f8f9fa !important;
    }

    .form-control, .form-select {
        border-left: none;
        padding-left: 0;
    }

    .form-control:focus, .form-select:focus {
        box-shadow: none;
        border-color: #86b7fe;
    }

    .form-control:focus + .input-group-text,
    .form-select:focus + .input-group-text {
        border-color: #86b7fe;
    }

    .card {
        border: none;
        border-radius: 15px;
        overflow: hidden;
    }

    .card-header {
        background-color: white;
        border-bottom: 1px solid rgba(0,0,0,.125);
        font-weight: 600;
    }

    .alert {
        border: none;
        border-radius: 10px;
    }

    .alert-danger {
        background-color: #f8d7da;
        border-left: 4px solid #dc3545;
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin-bottom: 0.5rem;
    }

    .breadcrumb-item a {
        color: #6c757d;
        transition: color 0.2s;
    }

    .breadcrumb-item a:hover {
        color: #0d6efd;
        text-decoration: underline;
    }

    .btn-success {
        background: linear-gradient(135deg, #198754 0%, #157347 100%);
        border: none;
        padding: 0.5rem 2rem;
        font-weight: 500;
    }

    .btn-success:hover {
        background: linear-gradient(135deg, #157347 0%, #0d5c3a 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2);
    }

    .btn-outline-secondary:hover {
        transform: translateY(-1px);
    }

    .btn-outline-danger:hover {
        background-color: #dc3545;
        color: white;
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .badge {
        font-weight: 500;
        padding: 0.5rem 1rem;
        border-radius: 20px;
    }

    .card-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\invoice-system\resources\views/categories/create.blade.php ENDPATH**/ ?>