<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Header Card -->
            <div class="card shadow-sm mb-4 border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-2">
                                    <li class="breadcrumb-item"><a href="<?php echo e(route('invoices.index')); ?>" class="text-decoration-none">Invoices</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Invoice #<?php echo e($invoice->invoice_no); ?></li>
                                </ol>
                            </nav>
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-size: 20px;">
                                    <i class="fas fa-file-invoice"></i>
                                </div>
                                <div>
                                    <h1 class="h3 fw-bold mb-0">Invoice Details</h1>
                                    <p class="text-muted mb-0">Invoice #<?php echo e($invoice->invoice_no); ?> - <?php echo e($invoice->customer->name); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-outline-primary" onclick="window.print()">
                                    <i class="fas fa-print me-1"></i>Print
                                </button>
                                <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-1"></i>Back to Invoices
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Invoice Card -->
            <div class="card shadow border-0">
                <!-- Company Header -->
                <div class="company-header bg-primary text-white p-4">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <h1 class="h2 fw-bold mb-2">DIVINE FITNESS</h1>
                            <div class="company-details">
                                <p class="mb-1 small">
    <i class="fas fa-map-marker-alt me-2"></i>
    <strong>HEAD OFFICE:</strong> SHED-8, PUSHKAR INDUSTRIAL PARK, OPP-
</p>
<p class="mb-1 small ps-4">
    ARUN MILL  ANIL STARCH MILL ROAD, SARASPUR, AHMEDABAD - 380018
</p>

   

                                <p class="mb-1 small">
                                    <i class="fas fa-receipt me-2"></i>
                                    <strong>GSTN:</strong> 24AVSPV0616L1Z2
                                </p>
                                <p class="mb-1 small">
                                    <i class="fas fa-globe me-2"></i>
                                    <strong>Website:</strong> https://divinefitnessequipment.com
                                </p>
                                <p class="mb-0 small">
                                    <i class="fas fa-phone me-2"></i>
                                    <strong>Phone:</strong> 7069278939
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="invoice-badge bg-white text-primary p-3 d-inline-block rounded">
                                <h2 class="h1 fw-bold mb-0">INVOICE</h2>
                                <p class="mb-0">#<?php echo e($invoice->invoice_no); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-body p-4">
                    <!-- Invoice Details -->
                    <div class="row mb-5">
                        <div class="col-md-6">
                            <div class="mb-4">
                                <div class="p-3 bg-light rounded">
                                    <h6 class="fw-bold mb-2 text-primary">BILLED TO:</h6>
                                    <div class="p-3 bg-white rounded">
                                        <p class="mb-1 fw-bold h5"><?php echo e($invoice->customer->name); ?></p>
                                        <?php if($invoice->customer->email): ?>
                                            <p class="mb-1 text-muted">
                                                <i class="fas fa-envelope me-1"></i><?php echo e($invoice->customer->email); ?>

                                            </p>
                                        <?php endif; ?>
                                        <?php if($invoice->customer->phone): ?>
                                            <p class="mb-0 text-muted">
                                                <i class="fas fa-phone me-1"></i><?php echo e($invoice->customer->phone); ?>

                                            </p>
                                        <?php endif; ?>
                                        <?php if($invoice->customer->address): ?>
                                            <p class="mt-2 mb-0 text-muted">
                                                <i class="fas fa-map-marker-alt me-1"></i><?php echo e($invoice->customer->address); ?>

                                            </p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="text-end">
                                <div class="p-3 bg-light rounded">
                                    <table class="table table-borderless mb-0">
                                        <tr>
                                            <td class="text-muted text-start ps-0">
                                                <i class="fas fa-calendar me-1"></i>Invoice Date:
                                            </td>
                                            <td class="fw-bold text-end pe-0"><?php echo e(\Carbon\Carbon::parse($invoice->invoice_date)->format('F d, Y')); ?></td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted text-start ps-0">
                                                <i class="fas fa-tag me-1"></i>Status:
                                            </td>
                                            <td class="text-end pe-0">
                                                <span class="badge bg-success"><?php echo e(ucfirst($invoice->status ?? 'Paid')); ?></span>
                                            </td>
                                        </tr>
                                        <?php if($invoice->due_date): ?>
                                        <tr>
                                            <td class="text-muted text-start ps-0">
                                                <i class="fas fa-clock me-1"></i>Due Date:
                                            </td>
                                            <td class="fw-bold text-end pe-0"><?php echo e(\Carbon\Carbon::parse($invoice->due_date)->format('F d, Y')); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Products Table -->
                    <div class="mb-5">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="table-primary">
                                    <tr>
                                        <th width="5%" class="text-center">#</th>
                                        <th width="45%">Product / Description</th>
                                        <th width="15%" class="text-center">Quantity</th>
                                        <th width="15%" class="text-end">Unit Price (₹)</th>
                                        <th width="20%" class="text-end">Amount (₹)</th>
                                    </tr>
                                </thead>
                               <tbody>
<?php $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<tr>
    <td class="text-center align-middle"><?php echo e($index + 1); ?></td>

    <td>
        <div class="d-flex align-items-center">

            
            <?php if($item->product && $item->product->image): ?>
                <img src="<?php echo e(asset('public/' . $item->product->image)); ?>"
                     alt="<?php echo e($item->product->name); ?>"
                     class="img-thumbnail me-3"
                     style="width:50px;height:50px;object-fit:cover;">
            <?php else: ?>
                <div class="avatar-circle bg-light text-secondary d-flex align-items-center justify-content-center me-3"
                     style="width:50px;height:50px;font-size:16px;">
                    <i class="fas fa-box"></i>
                </div>
            <?php endif; ?>

            
            <div>
                <strong class="d-block">
                    <?php echo e($item->product->name ?? 'Product Deleted'); ?>

                </strong>

                <?php if($item->product && $item->product->description): ?>
                    <small class="text-muted d-block" style="max-width:300px;">
                        <?php echo e(Str::limit($item->product->description, 80)); ?>

                    </small>
                <?php endif; ?>

                <small class="text-muted d-block">
                    SKU: <?php echo e($item->product->sku ?? 'N/A'); ?>

                </small>
            </div>

        </div>
    </td>

    <td class="text-center align-middle">
        <span class="badge bg-primary rounded-pill px-3 py-2">
            <?php echo e($item->quantity); ?>

        </span>
    </td>

    <td class="text-end align-middle">
        ₹<?php echo e(number_format($item->price, 2)); ?>

    </td>

    <td class="text-end fw-bold align-middle">
        ₹<?php echo e(number_format($item->subtotal, 2)); ?>

    </td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</tbody>


                    <!-- Totals Section -->
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="mb-3">
                                <h6 class="fw-bold mb-2 text-primary">Notes:</h6>
                                <?php if($invoice->notes): ?>
                                    <div class="p-3 bg-light rounded">
                                        <?php echo e($invoice->notes); ?>

                                    </div>
                                <?php else: ?>
                                    <p class="text-muted fst-italic">No notes provided.</p>
                                <?php endif; ?>
                            </div>
                            
                            <div>
                                <h6 class="fw-bold mb-2 text-primary">Terms & Conditions:</h6>
                                <?php if($invoice->terms): ?>
                                    <div class="p-3 bg-light rounded">
                                        <?php echo e($invoice->terms); ?>

                                    </div>
                                <?php else: ?>
                                    <p class="text-muted fst-italic">Standard terms and conditions apply.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="p-4 bg-light rounded">
                                <table class="table table-borderless mb-0">
                                    <tr>
                                        <td class="text-muted">Sub Amount:</td>
                                        <td class="text-end">₹<?php echo e(number_format($invoice->sub_amount, 2)); ?></td>
                                    </tr>
                                    <?php if($invoice->discount > 0): ?>
                                    <tr>
                                        <td class="text-muted">Discount:</td>
                                        <td class="text-end text-danger">- ₹<?php echo e(number_format($invoice->discount, 2)); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <td class="text-muted">Total Amount:</td>
                                        <td class="text-end fw-bold">₹<?php echo e(number_format($invoice->total_amount, 2)); ?></td>
                                    </tr>
                                    <?php if($invoice->gst_amount > 0): ?>
                                    <tr>
                                        <td class="text-muted">GST (18%):</td>
                                        <td class="text-end">+ ₹<?php echo e(number_format($invoice->gst_amount, 2)); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <td colspan="2"><hr class="my-2"></td>
                                    </tr>
                                    <tr>
                                        <td class="h5 fw-bold text-primary">Grand Total:</td>
                                        <td class="h4 fw-bold text-primary text-end">₹<?php echo e(number_format($invoice->grand_total, 2)); ?></td>
                                    </tr>
                                </table>
                            </div>
                            
                            <!-- Payment Status -->
                            <?php if($invoice->payment_status): ?>
                            <div class="mt-4 p-3 rounded" style="background-color: #e7f4ff;">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="fw-bold mb-1">Payment Status</h6>
                                        <p class="mb-0 text-muted small">
                                            <i class="fas fa-clock me-1"></i>
                                            Last updated: <?php echo e($invoice->updated_at->format('M d, Y h:i A')); ?>

                                        </p>
                                    </div>
                                    <div>
                                        <span class="badge bg-success p-2 px-3">
                                            <i class="fas fa-check-circle me-1"></i>
                                            <?php echo e($invoice->payment_status); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Footer -->
                <!--    <div class="mt-5 pt-4 border-top">-->
                <!--        <div class="row">-->
                <!--            <div class="col-md-4 text-center mb-3 mb-md-0">-->
                <!--                <div class="p-3 bg-light rounded">-->
                <!--                    <i class="fas fa-building fa-2x text-primary mb-2"></i>-->
                <!--                    <h6 class="fw-bold mb-1">DIVINE FITNESS</h6>-->
                <!--                    <p class="text-muted small mb-0">Official Invoice</p>-->
                <!--                </div>-->
                <!--            </div>-->
                <!--            <div class="col-md-4 text-center mb-3 mb-md-0">-->
                <!--                <div class="p-3 bg-light rounded">-->
                <!--                    <i class="fas fa-file-signature fa-2x text-primary mb-2"></i>-->
                <!--                    <h6 class="fw-bold mb-1">Authorized Signature</h6>-->
                <!--                    <p class="text-muted small mb-0">Digital Signature</p>-->
                <!--                </div>-->
                <!--            </div>-->
                <!--            <div class="col-md-4 text-center">-->
                <!--                <div class="p-3 bg-light rounded">-->
                <!--                    <i class="fas fa-info-circle fa-2x text-primary mb-2"></i>-->
                <!--                    <h6 class="fw-bold mb-1">Invoice Validity</h6>-->
                <!--                    <p class="text-muted small mb-0">Valid for 30 days</p>-->
                <!--                </div>-->
                <!--            </div>-->
                <!--        </div>-->
                <!--    </div>-->
                <!--</div>-->
                
                <!-- Card Footer with Actions -->
                <div class="card-footer bg-light py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <small class="text-muted">
                                <i class="fas fa-clock me-1"></i>
                                Created: <?php echo e($invoice->created_at->format('M d, Y')); ?>

                                <?php if($invoice->created_at != $invoice->updated_at): ?>
                                    | Updated: <?php echo e($invoice->updated_at->format('M d, Y')); ?>

                                <?php endif; ?>
                            </small>
                        </div>
                        <div class="d-flex gap-2">
                            <a href="<?php echo e(route('invoices.download', $invoice->id)); ?>" class="btn btn-info btn-sm">
                                <i class="fas fa-download me-1"></i>Download
                            </a>
                            <form action="<?php echo e(route('invoices.destroy', $invoice->id)); ?>" 
                                  method="POST" 
                                  class="d-inline delete-form">
                                <?php echo csrf_field(); ?> 
                                <?php echo method_field('DELETE'); ?>
                                <button type="button" 
                                        class="btn btn-danger btn-sm delete-btn"
                                        data-invoice-no="<?php echo e($invoice->invoice_no); ?>">
                                    <i class="fas fa-trash me-1"></i>Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Delete confirmation
    document.querySelectorAll('.delete-btn').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const invoiceNo = this.dataset.invoiceNo;
            const form = this.closest('form');
            
            if (confirm(`Are you sure you want to delete invoice #${invoiceNo}? This action cannot be undone.`)) {
                form.submit();
            }
        });
    });

    // Print specific styles
    function beforePrint() {
        document.querySelector('.card-footer').style.display = 'none';
        document.querySelectorAll('.btn-group').forEach(el => el.style.display = 'none');
    }

    function afterPrint() {
        document.querySelector('.card-footer').style.display = '';
        document.querySelectorAll('.btn-group').forEach(el => el.style.display = '');
    }

    // Print event listeners
    window.onbeforeprint = beforePrint;
    window.onafterprint = afterPrint;
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .avatar-circle {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }

    .card {
        border: none;
        border-radius: 15px;
        overflow: hidden;
    }

    .company-header {
        background: linear-gradient(135deg, #2c3e50 0%, #3498db 100%);
        border-bottom: 3px solid #2980b9;
    }

    .invoice-badge {
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }

    .company-details p {
        opacity: 0.9;
    }

    .company-details strong {
        opacity: 1;
    }

    .table {
        margin-bottom: 0;
    }

    .table thead th {
        border-bottom: 2px solid #dee2e6;
        font-weight: 600;
        color: #fff;
        padding: 1rem;
        background-color: #3498db;
    }

    .table tbody td {
        padding: 1rem;
        vertical-align: middle;
    }

    .table-bordered {
        border: 1px solid #dee2e6;
    }

    .table-bordered th,
    .table-bordered td {
        border: 1px solid #dee2e6;
    }

    .badge {
        font-weight: 500;
        padding: 0.35rem 0.65rem;
        border-radius: 20px;
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin-bottom: 0.5rem;
    }

    .breadcrumb-item.active {
        color: #495057;
        font-weight: 500;
    }

    .card-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
    }

    .img-thumbnail {
        border: 1px solid #dee2e6;
        border-radius: 8px;
        padding: 2px;
        background-color: white;
    }

    .bg-light {
        background-color: #f8f9fa !important;
    }

    /* Print styles */
    @media print {
        .company-header {
            background: #2c3e50 !important;
            -webkit-print-color-adjust: exact;
            color-adjust: exact;
        }
        
        .card-footer,
        .btn-group,
        .breadcrumb {
            display: none !important;
        }
        
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        
        .card-body {
            padding: 0 !important;
        }
        
        body {
            background-color: white !important;
        }
        
        .container {
            max-width: 100% !important;
            padding: 0 !important;
        }
        
        .table thead th {
            background-color: #3498db !important;
            -webkit-print-color-adjust: exact;
            color-adjust: exact;
        }
        
        .invoice-badge {
            background-color: white !important;
            color: #3498db !important;
            -webkit-print-color-adjust: exact;
            color-adjust: exact;
        }
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/jkmetal/public_html/resources/views/invoices/show.blade.php ENDPATH**/ ?>