

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <!-- Header Card -->
            <div class="card shadow-sm mb-4 border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-2">
                                    <li class="breadcrumb-item active" aria-current="page">Products</li>
                                </ol>
                            </nav>
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-size: 20px;">
                                    <i class="fas fa-boxes"></i>
                                </div>
                                <div>
                                    <h1 class="h3 fw-bold mb-0">Product Inventory</h1>
                                    <p class="text-muted mb-0">Manage all your products in one place</p>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <a href="<?php echo e(route('products.create')); ?>" class="btn btn-success px-4">
                                <i class="fas fa-plus-circle me-1"></i>Add New Product
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Card -->
            <div class="card shadow border-0">
                <div class="card-header bg-white py-3">
                    <h2 class="h5 mb-0 fw-semibold">
                        <i class="fas fa-list text-primary me-2"></i>
                        Product List
                    </h2>
                </div>
                
                <div class="card-body p-0">
                    <?php if($products->isEmpty()): ?>
                        <div class="text-center py-5">
                            <i class="fas fa-boxes fa-4x text-muted mb-3"></i>
                            <h3 class="h4 text-muted">No products found</h3>
                            <p class="text-muted">Add your first product to get started</p>
                            <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i>Add Product
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover mb-0" aria-label="Product list table">
                                <caption class="visually-hidden">List of products with details and actions</caption>
                                <thead class="table-light">
                                    <tr>
                                        <th scope="col" class="fw-semibold">Product</th>
                                        <th scope="col" class="fw-semibold">SKU</th>
                                        <th scope="col" class="fw-semibold">Category</th>
                                        <th scope="col" class="fw-semibold text-center">Price</th>
                                        <th scope="col" class="fw-semibold text-center">Stock</th>
                                        <th scope="col" class="fw-semibold">Status</th>
                                        <th scope="col" class="fw-semibold text-center">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="align-middle">
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="me-3">
                                                    <?php if($product->image): ?>
                                                       <img src="<?php echo e(asset('public/' . $product->image)); ?>" 
     alt="<?php echo e($product->name); ?>"
     class="img-thumbnail"
     style="width:150px; height:150px; object-fit:cover;">

                                                    <?php else: ?>
                                                        <div class="avatar-circle bg-light text-secondary d-flex align-items-center justify-content-center" 
                                                             style="width: 50px; height: 50px; font-size: 16px;">
                                                            <i class="fas fa-box"></i>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div>
                                                    <strong class="d-block"><?php echo e($product->name); ?></strong>
                                                    <small class="text-muted d-block" style="max-width: 200px;">
                                                        <?php echo e(Str::limit($product->description, 50)); ?>

                                                    </small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="text-muted">
                                                <?php echo e($product->sku ?: 'N/A'); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <?php
                                                // Get category name from category_id
                                                $category = \App\Models\Category::find($product->category_id);
                                            ?>
                                            <?php if($category): ?>
                                                <span class="badge bg-light text-dark">
                                                    <i class="fas fa-folder me-1"></i>
                                                    <?php echo e($category->name); ?>

                                                </span>
                                            <?php else: ?>
                                                <span class="text-muted">Uncategorized</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-end">
                                            <strong class="text-primary"><?php echo e(number_format($product->price, 2)); ?></strong>
                                        </td>
                                        <td class="text-center">
                                            <div class="d-flex flex-column align-items-center">
                                                <span class="fw-bold <?php echo e($product->quantity == 0 ? 'text-danger' : ($product->quantity < 10 ? 'text-warning' : 'text-success')); ?>">
                                                    <?php echo e($product->quantity); ?>

                                                </span>
                                                <!-- <?php if($product->unit): ?>
                                                    <small class="text-muted"><?php echo e($product->unit); ?></small>
                                                <?php endif; ?> -->
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?php echo e($product->status == 'active' ? 'success' : ($product->status == 'out_of_stock' ? 'warning' : 'secondary')); ?>">
                                                <?php echo e(ucfirst($product->status)); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <!-- <a href="<?php echo e(route('products.show', $product->id)); ?>" 
                                                   class="btn btn-sm btn-outline-info" 
                                                   title="View <?php echo e($product->name); ?>">
                                                    <span class="visually-hidden">View</span>
                                                    <i class="fas fa-eye"></i>
                                                </a> -->
                                                <a href="<?php echo e(route('products.edit', $product->id)); ?>" 
                                                   class="btn btn-sm btn-outline-warning" 
                                                   title="Edit <?php echo e($product->name); ?>">
                                                    <span class="visually-hidden">Edit</span>
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('products.destroy', $product->id)); ?>" 
                                                      method="POST" 
                                                      class="d-inline delete-form">
                                                    <?php echo csrf_field(); ?> 
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-danger delete-btn"
                                                            title="Delete <?php echo e($product->name); ?>"
                                                            data-product-name="<?php echo e($product->name); ?>">
                                                        <span class="visually-hidden">Delete</span>
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if($products->isNotEmpty()): ?>
                <div class="card-footer bg-light py-3">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <p class="mb-0">
                                <small class="text-muted">
                                    <i class="fas fa-info-circle me-1"></i>
                                    Showing <?php echo e($products->count()); ?> products
                                </small>
                            </p>
                        </div>
                        <!-- <div class="col-md-6 text-end">
                            <div class="btn-group" role="group" aria-label="Export and print actions">
                                <button type="button" class="btn btn-sm btn-outline-primary">
                                    <i class="fas fa-file-export me-1"></i>Export
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary">
                                    <i class="fas fa-print me-1"></i>Print
                                </button>
                            </div>
                        </div> -->
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Delete confirmation
    document.querySelectorAll('.delete-btn').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const productName = this.dataset.productName;
            const form = this.closest('form');
            
            if (confirm(`Are you sure you want to delete "${productName}"? This action cannot be undone.`)) {
                form.submit();
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .avatar-circle {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }

    .card {
        border: none;
        border-radius: 15px;
        overflow: hidden;
    }

    .card-header {
        background-color: white;
        border-bottom: 1px solid rgba(0,0,0,.125);
        font-weight: 600;
    }

    .table {
        margin-bottom: 0;
    }

    .table thead th {
        border-bottom: 2px solid #dee2e6;
        font-weight: 600;
        color: #495057;
        padding: 1rem;
    }

    .table tbody tr {
        transition: background-color 0.2s;
    }

    .table tbody tr:hover {
        background-color: rgba(13, 110, 253, 0.05);
    }

    .table tbody td {
        padding: 1rem;
        vertical-align: middle;
    }

    .badge {
        font-weight: 500;
        padding: 0.35rem 0.65rem;
        border-radius: 20px;
    }

    .bg-info.bg-opacity-10 {
        background-color: rgba(13, 202, 240, 0.1) !important;
    }

    .border-info.border-opacity-25 {
        border-color: rgba(13, 202, 240, 0.25) !important;
    }

    .btn-outline-info,
    .btn-outline-warning,
    .btn-outline-danger {
        border-width: 1px;
        padding: 0.25rem 0.5rem;
    }

    .btn-outline-info:hover,
    .btn-outline-warning:hover,
    .btn-outline-danger:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .btn-success {
        background: linear-gradient(135deg, #198754 0%, #157347 100%);
        border: none;
        padding: 0.5rem 1.5rem;
        font-weight: 500;
    }

    .btn-success:hover {
        background: linear-gradient(135deg, #157347 0%, #0d5c3a 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2);
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin-bottom: 0.5rem;
    }

    .breadcrumb-item.active {
        color: #495057;
        font-weight: 500;
    }

    .card-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
    }

    .img-thumbnail {
        border: 1px solid #dee2e6;
        border-radius: 8px;
        padding: 2px;
        background-color: white;
    }
    
    /* Accessibility improvements */
    .visually-hidden {
        position: absolute;
        width: 1px;
        height: 1px;
        padding: 0;
        margin: -1px;
        overflow: hidden;
        clip: rect(0, 0, 0, 0);
        white-space: nowrap;
        border: 0;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/jkmetal/public_html/resources/views/products/index.blade.php ENDPATH**/ ?>