

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <!-- Header Card -->
            <div class="card shadow-sm mb-4 border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <div>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-2">
                                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>" class="text-decoration-none">Dashboard</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Categories</li>
                                </ol>
                            </nav>
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-size: 20px;">
                                    <i class="fas fa-th-large"></i>
                                </div>
                                <div>
                                    <h1 class="h3 fw-bold mb-0">Category Management</h1>
                                    <p class="text-muted mb-0">Manage all product categories in your store</p>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <a href="<?php echo e(route('categories.create')); ?>" class="btn btn-success px-4">
                                <i class="fas fa-plus me-1"></i>Add New Category
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Card -->
            <div class="card shadow border-0">
                <div class="card-header bg-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 fw-semibold">
                            <i class="fas fa-th-list text-primary me-2"></i>
                            Categories List
                        </h5>
                        <?php if($categories->isNotEmpty()): ?>
                        <div class="d-flex align-items-center">
                            <div class="input-group input-group-sm" style="width: 250px;">
                                <span class="input-group-text bg-light border-end-0">
                                    <i class="fas fa-search text-muted"></i>
                                </span>
                                <input type="text" class="form-control border-start-0" id="searchInput" placeholder="Search categories...">
                            </div>
                            <button class="btn btn-light btn-sm ms-2" id="refreshBtn" title="Refresh">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="card-body p-0">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show m-4" role="alert">
                            <i class="fas fa-check-circle me-2"></i>
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show m-4" role="alert">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <?php echo e(session('error')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <?php if($categories->isEmpty()): ?>
                        <div class="text-center py-5">
                            <div class="mb-4">
                                <i class="fas fa-th-large fa-4x text-muted"></i>
                            </div>
                            <h4 class="text-muted mb-3">No categories found</h4>
                            <p class="text-muted mb-4">Get started by creating your first product category</p>
                            <a href="<?php echo e(route('categories.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i>Create First Category
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="fw-semibold ps-4">Category Name</th>
                                        <th class="fw-semibold">Description</th>
                                        <th class="fw-semibold text-center">Created At</th>
                                        <th class="fw-semibold text-center">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="align-middle">
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-circle bg-light-primary text-primary d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px; font-size: 16px;">
                                                    <i class="fas fa-folder"></i>
                                                </div>
                                                <div>
                                                    <h6 class="mb-0 fw-semibold"><?php echo e($category->name); ?></h6>
                                                    <small class="text-muted">ID: <?php echo e($category->id); ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-muted">
                                            <?php echo e(Str::limit($category->description, 30)); ?>

                                        </td>
                                        <td class="text-center text-muted">
                                            <i class="fas fa-calendar-alt me-1"></i>
                                            <?php echo e($category->created_at->format('M d, Y')); ?>

                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <!-- Edit Category -->
                                                <a href="<?php echo e(route('categories.edit', $category->id)); ?>"
                                                   class="btn btn-sm btn-outline-warning"
                                                   title="Edit"
                                                   data-bs-toggle="tooltip">
                                                    <i class="fas fa-edit"></i>
                                                </a>

                                                <!-- Delete Category -->
                                                <form action="<?php echo e(route('categories.destroy', $category->id)); ?>"
                                                      method="POST"
                                                      class="d-inline delete-form"
                                                      id="delete-form-<?php echo e($category->id); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button"
                                                            class="btn btn-sm btn-outline-danger delete-btn"
                                                            title="Delete"
                                                            data-bs-toggle="tooltip"
                                                            data-category-id="<?php echo e($category->id); ?>"
                                                            data-category-name="<?php echo e($category->name); ?>">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if($categories->isNotEmpty()): ?>
                <div class="card-footer bg-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <span class="text-muted">
                                Total: <?php echo e($categories->count()); ?> categories
                            </span>
                        </div>
                    
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Delete confirmation
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Bootstrap tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });

        // Delete button click handler
        document.querySelectorAll('.delete-btn').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                
                const categoryId = this.getAttribute('data-category-id');
                const categoryName = this.getAttribute('data-category-name');
                const form = document.getElementById('delete-form-' + categoryId);
                
                // Show confirmation dialog
                if (confirm(`Are you sure you want to delete "${categoryName}"? This action cannot be undone.`)) {
                    form.submit();
                }
            });
        });

        // Search functionality
        const searchInput = document.getElementById('searchInput');
        if (searchInput) {
            searchInput.addEventListener('keyup', function() {
                const searchTerm = this.value.toLowerCase();
                const rows = document.querySelectorAll('tbody tr');
                
                rows.forEach(row => {
                    const text = row.textContent.toLowerCase();
                    row.style.display = text.includes(searchTerm) ? '' : 'none';
                });
            });
        }

        // Refresh button
        const refreshBtn = document.getElementById('refreshBtn');
        if (refreshBtn) {
            refreshBtn.addEventListener('click', function() {
                location.reload();
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .avatar-circle {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }
    
    .bg-gradient-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }
    
    .bg-gradient-info {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    }
    
    .bg-gradient-success {
        background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
    }
    
    .bg-white-20 {
        background-color: rgba(255, 255, 255, 0.2);
    }
    
    .bg-light-primary {
        background-color: rgba(102, 126, 234, 0.1);
    }
    
    .table td {
        vertical-align: middle;
    }
    
    .table-hover tbody tr:hover {
        background-color: rgba(102, 126, 234, 0.05);
    }
    
    .text-truncate {
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    
    .btn-light {
        border: 1px solid #e9ecef;
    }
    
    .input-group-text {
        background-color: #f8f9fa;
        border-color: #e9ecef;
    }
    
    /* Delete button hover effect */
    .btn-outline-danger:hover {
        background-color: #dc3545;
        color: white;
    }
    
    .btn-outline-warning:hover {
        background-color: #ffc107;
        color: black;
    }
    
    /* Responsive table */
    @media (max-width: 768px) {
        .table-responsive {
            font-size: 0.9rem;
        }
        
        .btn-sm {
            padding: 0.25rem 0.5rem;
            font-size: 0.75rem;
        }
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/jkmetal/public_html/resources/views/categories/index.blade.php ENDPATH**/ ?>