

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Header Card -->
            <div class="card shadow-sm mb-4 border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-2">
                                    <li class="breadcrumb-item active" aria-current="page">Customers</li>
                                </ol>
                            </nav>
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-size: 20px;">
                                    <i class="fas fa-users"></i>
                                </div>
                                <div>
                                    <h1 class="h3 fw-bold mb-0">Customer Management</h1>
                                    <p class="text-muted mb-0">Manage all your customers in one place</p>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-success px-4">
                                <i class="fas fa-plus-circle me-1"></i>Add New Customer
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Card -->
            <div class="card shadow border-0">
                <div class="card-header bg-white py-3">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <h5 class="mb-0 fw-semibold">
                                <i class="fas fa-list text-primary me-2"></i>
                                Customer List
                            </h5>
                        </div>
                        <!-- <div class="col-md-6">
                            <div class="input-group">
                                <span class="input-group-text bg-light">
                                    <i class="fas fa-search text-primary"></i>
                                </span>
                                <input type="text" class="form-control" placeholder="Search customers...">
                                <button class="btn btn-outline-secondary" type="button">
                                    <i class="fas fa-filter"></i>
                                </button>
                            </div>
                        </div> -->
                    </div>
                </div>
                
                <div class="card-body p-0">
                    <?php if($customers->isEmpty()): ?>
                        <div class="text-center py-5">
                            <i class="fas fa-users fa-4x text-muted mb-3"></i>
                            <h4 class="text-muted">No customers found</h4>
                            <p class="text-muted">Add your first customer to get started</p>
                            <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i>Add Customer
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="ps-4">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="selectAll">
                                            </div>
                                        </th>
                                        <th class="fw-semibold">Customer</th>
                                        <th class="fw-semibold">Contact Information</th>
                                        <th class="fw-semibold">Status</th>
                                        <th class="fw-semibold text-center">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="align-middle">
                                        <td class="ps-4">
                                            <div class="form-check">
                                                <input class="form-check-input customer-checkbox" type="checkbox" value="<?php echo e($customer->id); ?>">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <!-- <div class="avatar-circle bg-primary text-white me-3" style="width: 40px; height: 40px; font-size: 16px;">
                                                    <?php echo e(strtoupper(substr($customer->name, 0, 1))); ?>

                                                </div> -->
                                                <div>
                                                    <strong class="d-block"><?php echo e($customer->name); ?></strong>
                                                    <small class="text-muted">ID: <?php echo e(str_pad($customer->id, 6, '0', STR_PAD_LEFT)); ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="contact-info">
                                                <?php if($customer->email): ?>
                                                    <div class="mb-1">
                                                        <i class="fas fa-envelope text-primary me-2"></i>
                                                        <a href="mailto:<?php echo e($customer->email); ?>" class="text-decoration-none">
                                                            <?php echo e($customer->email); ?>

                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if($customer->phone): ?>
                                                    <div>
                                                        <i class="fas fa-phone text-success me-2"></i>
                                                        <a href="tel:<?php echo e($customer->phone); ?>" class="text-decoration-none">
                                                            <?php echo e($customer->phone); ?>

                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-light text-dark">
                                                <i class="fas fa-calendar-alt me-1"></i>
                                                <?php echo e($customer->created_at->format('M d, Y')); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <!-- <a href="<?php echo e(route('customers.show', $customer->id)); ?>" 
                                                   class="btn btn-sm btn-outline-info" 
                                                   title="View Details">
                                                    <i class="fas fa-eye"></i>
                                                </a> -->
                                                <a href="<?php echo e(route('customers.edit', $customer->id)); ?>" 
                                                   class="btn btn-sm btn-outline-warning" 
                                                   title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('customers.destroy', $customer->id)); ?>" 
                                                      method="POST" 
                                                      class="d-inline delete-form">
                                                    <?php echo csrf_field(); ?> 
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-danger delete-btn"
                                                            title="Delete"
                                                            data-customer-name="<?php echo e($customer->name); ?>">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Bulk Actions -->
                        <div class="border-top p-3" id="bulkActions" style="display: none;">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <span class="text-muted" id="selectedCount">0</span> customers selected
                                </div>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary btn-sm">
                                        <i class="fas fa-download me-1"></i>Export
                                    </button>
                                    <button type="button" class="btn btn-outline-danger btn-sm">
                                        <i class="fas fa-trash me-1"></i>Delete Selected
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary btn-sm" id="clearSelection">
                                        Clear
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Card Footer -->
                <div class="card-footer bg-light py-3">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Showing <?php echo e($customers->count()); ?> customers
                            </small>
                        </div>
                        <div class="col-md-6 text-end">
                            <!-- Pagination would go here -->
                            <!-- <nav aria-label="Page navigation">
                                <ul class="pagination pagination-sm justify-content-end mb-0">
                                    <li class="page-item disabled">
                                        <a class="page-link" href="#" tabindex="-1">Previous</a>
                                    </li>
                                    <li class="page-item active"><a class="page-link" href="#">1</a></li>
                                    <li class="page-item"><a class="page-link" href="#">2</a></li>
                                    <li class="page-item"><a class="page-link" href="#">3</a></li>
                                    <li class="page-item">
                                        <a class="page-link" href="#">Next</a>
                                    </li>
                                </ul>
                            </nav> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Select all checkbox
    document.getElementById('selectAll').addEventListener('change', function() {
        const checkboxes = document.querySelectorAll('.customer-checkbox');
        checkboxes.forEach(checkbox => checkbox.checked = this.checked);
        updateBulkActions();
    });

    // Individual checkbox change
    document.querySelectorAll('.customer-checkbox').forEach(checkbox => {
        checkbox.addEventListener('change', updateBulkActions);
    });

    function updateBulkActions() {
        const selectedCount = document.querySelectorAll('.customer-checkbox:checked').length;
        const bulkActions = document.getElementById('bulkActions');
        const selectedCountElement = document.getElementById('selectedCount');
        
        selectedCountElement.textContent = selectedCount;
        
        if (selectedCount > 0) {
            bulkActions.style.display = 'block';
        } else {
            bulkActions.style.display = 'none';
        }
    }

    // Clear selection
    document.getElementById('clearSelection')?.addEventListener('click', function() {
        document.querySelectorAll('.customer-checkbox').forEach(cb => cb.checked = false);
        document.getElementById('selectAll').checked = false;
        updateBulkActions();
    });

    // Delete confirmation
    document.querySelectorAll('.delete-btn').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const customerName = this.dataset.customerName;
            const form = this.closest('form');
            
            if (confirm(`Are you sure you want to delete "${customerName}"? This action cannot be undone.`)) {
                form.submit();
            }
        });
    });

    // Search functionality
    document.querySelector('input[placeholder="Search customers..."]').addEventListener('input', function(e) {
        const searchTerm = e.target.value.toLowerCase();
        const rows = document.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            const text = row.textContent.toLowerCase();
            row.style.display = text.includes(searchTerm) ? '' : 'none';
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .avatar-circle {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }

    .card {
        border: none;
        border-radius: 15px;
        overflow: hidden;
    }

    .card-header {
        background-color: white;
        border-bottom: 1px solid rgba(0,0,0,.125);
        font-weight: 600;
    }

    .table {
        margin-bottom: 0;
    }

    .table thead th {
        border-bottom: 2px solid #dee2e6;
        font-weight: 600;
        color: #495057;
        padding: 1rem;
    }

    .table tbody tr {
        transition: background-color 0.2s;
    }

    .table tbody tr:hover {
        background-color: rgba(13, 110, 253, 0.05);
    }

    .table tbody td {
        padding: 1rem;
        vertical-align: middle;
    }

    .contact-info a {
        color: #495057;
        transition: color 0.2s;
    }

    .contact-info a:hover {
        color: #0d6efd;
        text-decoration: underline;
    }

    .badge {
        font-weight: 500;
        padding: 0.35rem 0.65rem;
        border-radius: 20px;
    }

    .btn-outline-info,
    .btn-outline-warning,
    .btn-outline-danger {
        border-width: 1px;
        padding: 0.25rem 0.5rem;
    }

    .btn-outline-info:hover,
    .btn-outline-warning:hover,
    .btn-outline-danger:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .btn-success {
        background: linear-gradient(135deg, #198754 0%, #157347 100%);
        border: none;
        padding: 0.5rem 1.5rem;
        font-weight: 500;
    }

    .btn-success:hover {
        background: linear-gradient(135deg, #157347 0%, #0d5c3a 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2);
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin-bottom: 0.5rem;
    }

    .breadcrumb-item.active {
        color: #495057;
        font-weight: 500;
    }

    .input-group-text {
        background-color: #f8f9fa !important;
        border-right: none;
    }

    .form-control {
        border-left: none;
    }

    .form-control:focus {
        box-shadow: none;
        border-color: #86b7fe;
    }

    .form-control:focus + .input-group-text {
        border-color: #86b7fe;
    }

    .card-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
    }

    .pagination .page-link {
        color: #495057;
        border: 1px solid #dee2e6;
        margin: 0 2px;
        border-radius: 5px;
    }

    .pagination .page-item.active .page-link {
        background-color: #0d6efd;
        border-color: #0d6efd;
        color: white;
    }

    .pagination .page-link:hover {
        background-color: #e9ecef;
        border-color: #dee2e6;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/jkmetal/public_html/resources/views/customers/index.blade.php ENDPATH**/ ?>