

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <!-- Header Card -->
            <div class="card shadow-sm mb-4 border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-2">
                                    <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
                                </ol>
                            </nav>
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-size: 20px;">
                                    <i class="fas fa-tachometer-alt"></i>
                                </div>
                                <div>
                                    <h1 class="h3 fw-bold mb-0">Welcome, <?php echo e(auth()->user()->name); ?></h1>
                                    <p class="text-muted mb-0">Invoice System Dashboard - Manage everything from one place</p>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <span class="badge bg-light text-dark fs-6 p-2">
                                <i class="fas fa-calendar-alt me-1"></i>
                                <?php echo e(now()->format('F d, Y')); ?>

                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stats Cards -->
            <div class="row mb-4">
                <div class="col-xl-4 col-md-6 mb-4">
                    <div class="card border-start border-primary border-4 shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col me-2">
                                    <div class="text-xs fw-bold text-primary text-uppercase mb-1">
                                        Total Customers
                                    </div>
                                    <div class="h5 mb-0 fw-bold text-gray-800"><?php echo e(\App\Models\Customer::count()); ?></div>
                                    <div class="mt-2 mb-0 text-muted text-xs">
                                        <span class="text-success me-2">
                                            <i class="fas fa-user-plus me-1"></i>
                                            Active users
                                        </span>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-users fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-4 col-md-6 mb-4">
                    <div class="card border-start border-success border-4 shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col me-2">
                                    <div class="text-xs fw-bold text-success text-uppercase mb-1">
                                        Total Products
                                    </div>
                                    <div class="h5 mb-0 fw-bold text-gray-800"><?php echo e(\App\Models\Product::count()); ?></div>
                                    <div class="mt-2 mb-0 text-muted text-xs">
                                        <span class="text-info me-2">
                                            <i class="fas fa-box me-1"></i>
                                            In inventory
                                        </span>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-boxes fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-4 col-md-6 mb-4">
                    <div class="card border-start border-info border-4 shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col me-2">
                                    <div class="text-xs fw-bold text-info text-uppercase mb-1">
                                        Total Invoices
                                    </div>
                                    <div class="h5 mb-0 fw-bold text-gray-800"><?php echo e(\App\Models\Invoice::count()); ?></div>
                                    <div class="mt-2 mb-0 text-muted text-xs">
                                        <span class="text-warning me-2">
                                            <i class="fas fa-file-invoice me-1"></i>
                                            All time
                                        </span>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-file-invoice-dollar fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


              <div class="col-xl-4 col-md-6 mb-4">
                    <div class="card border-start border-info border-4 shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col me-2">
                                    <div class="text-xs fw-bold text-info text-uppercase mb-1">
                                        Total Category
                                    </div>
                                    <div class="h5 mb-0 fw-bold text-gray-800"><?php echo e(\App\Models\Category::count()); ?></div>
                                    <div class="mt-2 mb-0 text-muted text-xs">
                                        <span class="text-warning me-2">
                                            <i class="fas fa-file-invoice me-1"></i>
                                            All time
                                        </span>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-file-invoice-dollar fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Cards -->
            <div class="row g-4">
                <!-- Customers Card -->
                <div class="col-md-4">
                    <div class="card shadow border-0 h-100">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0 fw-semibold">
                                <i class="fas fa-users text-primary me-2"></i>
                                Customers
                            </h5>
                        </div>
                        <div class="card-body p-4">
                            <div class="text-center mb-4">
                                <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center mx-auto mb-3" style="width: 70px; height: 70px; font-size: 24px;">
                                    <i class="fas fa-user-friends"></i>
                                </div>
                                <h3 class="fw-bold"><?php echo e(\App\Models\Customer::count()); ?></h3>
                                <p class="text-muted">Total Registered Customers</p>
                            </div>
                            <div class="mt-3">
                                <a href="<?php echo e(route('customers.index')); ?>" class="btn btn-success w-100">
                                    <i class="fas fa-eye me-1"></i>View All Customers
                                </a>
                                <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-outline-primary w-100 mt-2">
                                    <i class="fas fa-plus me-1"></i>Add New Customer
                                </a>
                            </div>
                        </div>
                        <div class="card-footer bg-light py-3">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Manage your customer database
                            </small>
                        </div>
                    </div>
                </div>

                <!-- Products Card -->
                <div class="col-md-4">
                    <div class="card shadow border-0 h-100">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0 fw-semibold">
                                <i class="fas fa-box text-primary me-2"></i>
                                Products
                            </h5>
                        </div>
                        <div class="card-body p-4">
                            <div class="text-center mb-4">
                                <div class="avatar-circle bg-success text-white d-flex align-items-center justify-content-center mx-auto mb-3" style="width: 70px; height: 70px; font-size: 24px;">
                                    <i class="fas fa-box-open"></i>
                                </div>
                                <h3 class="fw-bold"><?php echo e(\App\Models\Product::count()); ?></h3>
                                <p class="text-muted">Total Products in Inventory</p>
                            </div>
                            <div class="mt-3">
                                <a href="<?php echo e(route('products.index')); ?>" class="btn btn-success w-100">
                                    <i class="fas fa-eye me-1"></i>View All Products
                                </a>
                                <a href="<?php echo e(route('products.create')); ?>" class="btn btn-outline-primary w-100 mt-2">
                                    <i class="fas fa-plus me-1"></i>Add New Product
                                </a>
                            </div>
                        </div>
                        <div class="card-footer bg-light py-3">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Manage your product inventory
                            </small>
                        </div>
                    </div>
                </div>

                <!-- Invoices Card -->
                <div class="col-md-4">
                    <div class="card shadow border-0 h-100">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0 fw-semibold">
                                <i class="fas fa-file-invoice text-primary me-2"></i>
                                Invoices
                            </h5>
                        </div>
                        <div class="card-body p-4">
                            <div class="text-center mb-4">
                                <div class="avatar-circle bg-info text-white d-flex align-items-center justify-content-center mx-auto mb-3" style="width: 70px; height: 70px; font-size: 24px;">
                                    <i class="fas fa-receipt"></i>
                                </div>
                                <h3 class="fw-bold"><?php echo e(\App\Models\Invoice::count()); ?></h3>
                                <p class="text-muted">Total Invoices Generated</p>
                            </div>
                            <div class="mt-3">
                                <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-success w-100">
                                    <i class="fas fa-eye me-1"></i>View All Invoices
                                </a>
                                <a href="<?php echo e(route('invoices.create')); ?>" class="btn btn-outline-primary w-100 mt-2">
                                    <i class="fas fa-plus me-1"></i>Create New Invoice
                                </a>
                            </div>
                        </div>
                        <div class="card-footer bg-light py-3">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Manage your invoices and billing
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .avatar-circle {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }

    .card {
        border: none;
        border-radius: 15px;
        overflow: hidden;
    }

    .card-header {
        background-color: white;
        border-bottom: 1px solid rgba(0,0,0,.125);
        font-weight: 600;
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin-bottom: 0.5rem;
    }

    .breadcrumb-item.active {
        color: #495057;
        font-weight: 500;
    }

    .badge {
        font-weight: 500;
        padding: 0.5rem 1rem;
        border-radius: 20px;
    }

    .card-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
    }

    /* Stats cards */
    .border-start {
        border-left-width: 4px !important;
    }

    .text-xs {
        font-size: 0.75rem;
    }

    .text-gray-300 {
        color: #dddfeb !important;
    }

    .text-gray-800 {
        color: #5a5c69 !important;
    }

    .btn-success {
        background: linear-gradient(135deg, #198754 0%, #157347 100%);
        border: none;
        padding: 0.5rem 1.5rem;
        font-weight: 500;
    }

    .btn-success:hover {
        background: linear-gradient(135deg, #157347 0%, #0d5c3a 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2);
    }

    .btn-outline-primary:hover {
        transform: translateY(-1px);
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\invoice-system\resources\views/dashboard.blade.php ENDPATH**/ ?>