

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <!-- Header Card -->
            <div class="card shadow-sm mb-4 border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-2">
                                    <li class="breadcrumb-item active" aria-current="page">Quotations</li>
                                </ol>
                            </nav>
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-size: 20px;">
                                    <i class="fas fa-file-invoice-dollar"></i>
                                </div>
                                <div>
                                    <h1 class="h3 fw-bold mb-0">Quotation Management</h1>
                                    <p class="text-muted mb-0">Manage all your quotations in one place</p>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <a href="<?php echo e(route('quotation.create')); ?>" class="btn btn-success px-4">
                                <i class="fas fa-plus-circle me-1"></i>Create New Quotation
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Card -->
            <div class="card shadow border-0">
                <div class="card-header bg-white py-3">
                    <h5 class="mb-0 fw-semibold">
                        <i class="fas fa-list text-primary me-2"></i>
                        Quotation List
                    </h5>
                </div>
                
                <div class="card-body p-0">
                    <?php if($quotations->isEmpty()): ?>
                        <div class="text-center py-5">
                            <i class="fas fa-file-invoice-dollar fa-4x text-muted mb-3"></i>
                            <h4 class="text-muted">No quotations found</h4>
                            <p class="text-muted">Create your first quotation to get started</p>
                            <a href="<?php echo e(route('quotation.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i>Create Quotation
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="fw-semibold">Quotation No</th>
                                        <th class="fw-semibold">Customer</th>
                                        <th class="fw-semibold">Date</th>
                                        <th class="fw-semibold text-end">Sub Amount</th>
                                        <th class="fw-semibold text-end">Discount</th>
                                        <th class="fw-semibold text-end">GST</th>
                                        <th class="fw-semibold text-end">Grand Total</th>
                                        <th class="fw-semibold">Payment Status</th>
                                        <th class="fw-semibold text-center">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $quotations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quotation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="align-middle">
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="me-3">
                                                    <div class="avatar-circle bg-light text-primary d-flex align-items-center justify-content-center" 
                                                         style="width: 40px; height: 40px; font-size: 14px;">
                                                        <i class="fas fa-file-invoice"></i>
                                                    </div>
                                                </div>
                                                <div>
                                                    <strong class="d-block"><?php echo e($quotation->invoice_no); ?></strong>
                                                    <small class="text-muted d-block">
                                                        Created: <?php echo e($quotation->created_at->format('d-M-Y')); ?>

                                                    </small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <strong class="d-block"><?php echo e($quotation->customer->name); ?></strong>
                                                <?php if($quotation->customer->phone): ?>
                                                    <small class="text-muted d-block">
                                                        <i class="fas fa-phone me-1"></i><?php echo e($quotation->customer->phone); ?>

                                                    </small>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="text-muted">
                                                <?php echo e(\Carbon\Carbon::parse($quotation->invoice_date)->format('d-M-Y')); ?>

                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <strong class="text-primary">₹<?php echo e(number_format($quotation->sub_amount, 2)); ?></strong>
                                        </td>
                                        <td class="text-end">
                                            <?php if($quotation->discount > 0): ?>
                                                <span class="text-danger">-₹<?php echo e(number_format($quotation->discount, 2)); ?></span>
                                            <?php else: ?>
                                                <span class="text-muted">₹0.00</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-end">
                                            <span class="text-warning">₹<?php echo e(number_format($quotation->gst_amount, 2)); ?></span>
                                        </td>
                                        <td class="text-end">
                                            <strong class="text-success">₹<?php echo e(number_format($quotation->grand_total, 2)); ?></strong>
                                        </td>
                                        <td>
                                            <?php
                                                $statusColors = [
                                                    'paid' => 'success',
                                                    'partial' => 'warning',
                                                    'pending' => 'secondary',
                                                    'overdue' => 'danger'
                                                ];
                                                $color = $statusColors[$quotation->payment_status] ?? 'secondary';
                                            ?>
                                            <span class="badge bg-<?php echo e($color); ?>">
                                                <?php echo e(ucfirst(str_replace('_', ' ', $quotation->payment_status))); ?>

                                            </span>
                                            <?php if($quotation->due_amount > 0): ?>
                                                <small class="d-block text-muted">
                                                    Due: ₹<?php echo e(number_format($quotation->due_amount, 2)); ?>

                                                </small>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <a href="<?php echo e(route('quotations.show', $quotation->id)); ?>" 
                                                   class="btn btn-sm btn-outline-info" 
                                                   title="View">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('quotations.print', $quotation->id)); ?>" 
                                                   class="btn btn-sm btn-outline-primary" 
                                                   title="Print" target="_blank">
                                                    <i class="fas fa-print"></i>
                                                </a>
                                                <a href="<?php echo e(route('quotations.edit', $quotation->id)); ?>" 
                                                   class="btn btn-sm btn-outline-warning" 
                                                   title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('quotations.destroy', $quotation->id)); ?>" 
                                                      method="POST" 
                                                      class="d-inline delete-form">
                                                    <?php echo csrf_field(); ?> 
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-danger delete-btn"
                                                            title="Delete"
                                                            data-quotation-no="<?php echo e($quotation->invoice_no); ?>">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if($quotations->isNotEmpty()): ?>
                <div class="card-footer bg-light py-3">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Showing <?php echo e($quotations->firstItem()); ?> to <?php echo e($quotations->lastItem()); ?> of <?php echo e($quotations->total()); ?> quotations
                            </small>
                        </div>
                        <div class="col-md-6 text-end">
                            <?php echo e($quotations->links()); ?>

                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Delete confirmation
    document.querySelectorAll('.delete-btn').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const quotationNo = this.dataset.quotationNo;
            const form = this.closest('form');
            
            if (confirm(`Are you sure you want to delete quotation "${quotationNo}"? This action cannot be undone.`)) {
                form.submit();
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .avatar-circle {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }

    .card {
        border: none;
        border-radius: 15px;
        overflow: hidden;
    }

    .card-header {
        background-color: white;
        border-bottom: 1px solid rgba(0,0,0,.125);
        font-weight: 600;
    }

    .table {
        margin-bottom: 0;
    }

    .table thead th {
        border-bottom: 2px solid #dee2e6;
        font-weight: 600;
        color: #495057;
        padding: 1rem;
    }

    .table tbody tr {
        transition: background-color 0.2s;
    }

    .table tbody tr:hover {
        background-color: rgba(13, 110, 253, 0.05);
    }

    .table tbody td {
        padding: 1rem;
        vertical-align: middle;
    }

    .badge {
        font-weight: 500;
        padding: 0.35rem 0.65rem;
        border-radius: 20px;
    }

    .btn-outline-info,
    .btn-outline-warning,
    .btn-outline-danger {
        border-width: 1px;
        padding: 0.25rem 0.5rem;
    }

    .btn-outline-info:hover,
    .btn-outline-warning:hover,
    .btn-outline-danger:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .btn-success {
        background: linear-gradient(135deg, #198754 0%, #157347 100%);
        border: none;
        padding: 0.5rem 1.5rem;
        font-weight: 500;
    }

    .btn-success:hover {
        background: linear-gradient(135deg, #157347 0%, #0d5c3a 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2);
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin-bottom: 0.5rem;
    }

    .breadcrumb-item.active {
        color: #495057;
        font-weight: 500;
    }

    .card-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\invoice-system\resources\views/quotation/index.blade.php ENDPATH**/ ?>