<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Quotation - Divine Fitness</title>
    
    <!-- Include html2pdf library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 12px;
            color: #333;
            margin: 0;
            padding: 20px;
            background-color: #f8f9fa;
        }
        .container {
            width: 100%;
            max-width: 1100px;
            margin: 0 auto;
            position: relative;
            background-color: white;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            padding: 20px;
        }
        
        /* Action buttons - only for screen */
        .action-buttons {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            background: white;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        .action-buttons button {
            display: block;
            width: 100%;
            margin: 6px 0;
            padding: 10px 18px;
            background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%);
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 13px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .action-buttons button:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }
        .action-buttons button.print {
            background: linear-gradient(135deg, #008CBA 0%, #007B9A 100%);
        }
        
        /* Print styles */
        @media print {
            .action-buttons {
                display: none !important;
            }
            body {
                padding: 0;
                margin: 0;
                background-color: white;
            }
            .container {
                box-shadow: none;
                padding: 0;
            }
        }
        
        .header {
            text-align: center;
            border-bottom: 3px solid #2c3e50;
            padding-bottom: 15px;
            margin-bottom: 25px;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding: 20px;
            border-radius: 10px;
        }
        .company-details {
            text-align: center;
            font-size: 11px;
            line-height: 1.4;
            color: #555;
        }
        .info-table {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .info-table td {
            padding: 10px;
            vertical-align: top;
            border-bottom: 1px solid #e9ecef;
        }
        .quotation-title {
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            margin: 20px 0;
            color: #2c3e50;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 25px;
            font-size: 11px;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .invoice-table th,
        .invoice-table td {
            border: 1px solid #dee2e6;
            padding: 10px;
            vertical-align: middle;
        }
        .invoice-table th {
            background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
            color: white;
            text-align: center;
            font-weight: 600;
            font-size: 12px;
            border: none;
        }
        .text-center { text-align: center; }
        .text-left { text-align: left; }
        .text-right { text-align: right; }
        
        .total-summary {
            width: 40%;
            float: right;
            margin-top: 15px;
            border-collapse: collapse;
            background: #f8f9fa;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .total-summary td {
            border: 1px solid #dee2e6;
            padding: 10px;
            background: white;
        }
        .total-summary tr:last-child td {
            background: #2c3e50;
            color: white;
            font-weight: bold;
            font-size: 13px;
        }
        .terms-section {
            margin-top: 30px;
            font-size: 11px;
            clear: both;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .terms-section h4 {
            margin: 0 0 15px 0;
            font-size: 14px;
            color: #2c3e50;
            padding-bottom: 8px;
            border-bottom: 2px solid #111;
        }
   .terms-list {
    text-align: justify;
    text-justify: inter-word;
    line-height: 1.8;
    font-size: 14px;
    color: #333;
}

.term-item {
    text-align: justify;
    text-justify: inter-word;
    margin-bottom: 5px;
}

.sub-terms {
    text-align: justify;
    text-justify: inter-word;
    font-size: 13.5px;
    line-height: 1.6;
}

.term-spacer {
    height: 8px;
    margin: 5px 0;
    border-bottom: 1px dashed #e0e0e0;
}

.column {
    background: #ffffff;
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 20px;
    border: 1px solid #e0e0e0;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
}

.column-title {
    font-size: 16px;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 15px;
    padding-bottom: 10px;
    border-bottom: 2px solid #111;
    display: flex;
    align-items: center;
}
        .terms-list ul {
            margin: 5px 0;
            padding-left: 20px;
        }
        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 11px;
            border-top: 2px dashed #dee2e6;
            padding-top: 15px;
            color: #666;
        }
        .clearfix { clear: both; }
        
        .signature-line {
            margin-top: 30px;
            font-size: 11px;
            text-align: right;
        }
        .bank-details {
            border: 2px solid #2c3e50;
            padding: 15px;
            margin: 20px 0;
            background-color: #f8f9fa;
            font-size: 11px;
            border-radius: 8px;
        }
        .page-break {
            page-break-before: always;
            margin-top: 40px;
        }
        
        /* Image styling */
        .product-image {
            width: 100px;
            height: 100px;
            object-fit: cover;
            display: block;
            margin: 0 auto;
            border-radius: 6px;
            border: 1px solid #dee2e6;
        }
        .image-placeholder {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #f5f5f5 0%, #e9ecef 100%);
            border: 2px dashed #adb5bd;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6c757d;
            font-size: 10px;
            margin: 0 auto;
            border-radius: 6px;
        }
        
        /* Three column layout */
        .three-columns {
            display: flex;
            justify-content: space-between;
            margin: 30px 0;
            flex-wrap: wrap;
            gap: 20px;
        }
       .column {
    flex: 1;
    min-width: 280px;
    padding: 20px;
    border: 2px solid #000000; /* 黑色边框 */
    border-radius: 10px;
    background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    transition: transform 0.3s ease;
}
        .column:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.12);
        }
      .column-title {
    font-weight: 700;
    margin-bottom: 15px;
    padding-bottom: 10px;
    border-bottom: 3px solid #000000; /* 改为黑色 */
    font-size: 14px;
    color: #2c3e50;
    text-transform: uppercase;
    letter-spacing: 1px;
}
        .column-content {
            font-size: 11px;
            line-height: 1.6;
            color: #444;
        }
        
        /* Address box */
        .address-box {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border: 2px solid #2c3e50;
            padding: 20px;
            margin: 25px 0;
            font-size: 11px;
            line-height: 1.6;
            border-radius: 8px;
        }
        
        /* Badge styling */
        .badge {
            display: inline-block;
            padding: 4px 10px;
            background: #4CAF50;
            color: white;
            border-radius: 20px;
            font-size: 10px;
            font-weight: 600;
            margin: 2px;
        }
        
        /* Highlight important text */
        .highlight {
            background-color: #fff3cd;
            padding: 2px 6px;
            border-radius: 4px;
            font-weight: 500;
        }
        
        /* Status indicators */
        .status-active {
            color: #28a745;
            font-weight: 600;
        }
        .status-pending {
            color: #ffc107;
            font-weight: 600;
        }
        .status-cancelled {
            color: #dc3545;
            font-weight: 600;
        }
        
        /* Quote number styling */
.quote-number {
    font-size: 18px;
    font-weight: 700;
    color: #000;                 /* Black text */
    background: #ffffff;
    padding: 10px 20px;
    border-radius: 8px;
    display: inline-block;
    margin: 10px 0;

    border: 1px solid #ddd;      /* Neutral border */

    box-shadow:
        0 2px 4px rgba(0, 0, 0, 0.08);  /* Simple neutral shadow */
}



        /* Product name styling */
        .product-name {
            font-weight: 600;
            color: #2c3e50;
            font-size: 12px;
        }
        
        /* Price styling */
        .price-amount {
            font-weight: 700;
            color: #000000;
            font-size: 12px;
        }
        
        /* Total amount styling */
        .total-amount {
            font-size: 16px;
            font-weight: 700;
            color: #2c3e50;
        }
        
        /* Section spacing */
        .section-spacing {
            margin: 30px 0;
            padding: 20px 0;
        }
    </style>
</head>
<body>

<div class="action-buttons">
    <button onclick="downloadPDF()">📥 Download PDF</button>
    <button class="print" onclick="window.print()">🖨️ Print Quotation</button>
</div>

<div class="container" id="invoice-content">

    
    <div class="header">
        <div style="margin-bottom: 15px;">
         <div style="text-align: center; margin-bottom: 15px;">
   <img src="<?php echo e('http://www.jk-metal.in/public/LOGO.jpeg'); ?>" 
     alt="Divine Fitness Logo" 
     style="max-height: 180px; max-width: 580px; display: block; margin: 0 auto 10px;"
     crossorigin="anonymous"
     onerror="this.onerror=null; this.style.display='none'; this.parentNode.innerHTML='<h3 style=\'margin: 5px 0; font-size: 28px; color: #ff0000;\'>DIVINE FITNESS</h3>';">
  
           <div class="quote-number">
    QUOTATION #<?php echo e($invoice->invoice_no ?? 'INV-1767868547'); ?>

</div>
        </div>
        <div class="company-details">
            <div style="margin-bottom: 10px;">
                <strong>HEAD OFFICE:</strong><br>
                SHED-8, PUSHKAR INDUSTRIAL PARK, OPP-ARUN MILL<br>
                ANIL STARCH MILL ROAD, SARASPUR, AHMEDABAD - 380018
            </div>
            <div style="display: flex; justify-content: center; gap: 30px; margin-top: 10px;">
                <div><strong>GSTN:</strong> 24AVSPV0616L1Z2</div>
                <div><strong>Website:</strong> https://divinefitnessequipment.com</div>
                <div><strong>Phone:</strong> 7069278939</div>
            </div>
        </div>
    </div>

    
    <div class="quotation-title">
        COMMERCIAL QUOTATION
    </div>

    
    <table class="info-table">
        <tr>
            <td width="50%" style="border-right: 1px solid #e9ecef;">
                <strong style="color: #2c3e50; font-size: 13px;">BILL TO:</strong><br>
                <div style="margin-top: 8px; font-size: 13px;">
                    <strong><?php echo e($invoice->customer_name ?? 'Divine Fitness'); ?></strong><br>
                    <?php echo e($invoice->address ?? 'SHED-8, Pushkar Industrial Park, Opp - Arun Mill, Anil Starch Mill Road, Saraspur, Ahmedabad'); ?>

                    <?php if($invoice->mobile): ?>
                    <br><span class="badge">📞 <?php echo e($invoice->mobile); ?></span>
                    <?php endif; ?>
                </div>
            </td>
            <td width="50%">
                <table style="width: 100%;">
                    <tr>
                        <td><strong>Quotation Date:</strong></td>
                        <td class="text-right"><?php echo e(\Carbon\Carbon::parse($invoice->invoice_date ?? '12-Dec-2025')->format('d-M-Y')); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Quotation No:</strong></td>
                        <td class="text-right"><span class="highlight"><?php echo e($invoice->invoice_no ?? 'R-1/Q/25-26/5363'); ?></span></td>
                    </tr>
                    <tr>
                        <td><strong>Validity:</strong></td>
                        <td class="text-right">30 Days</td>
                    </tr>
                    <tr>
                        <td><strong>Payment Terms:</strong></td>
                        <td class="text-right">100% Advance</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    
    <div style="margin: 25px 0 15px 0;">
        <h4 style="color: #2c3e50; margin-bottom: 10px; font-size: 16px; padding-bottom: 8px; border-bottom: 2px solid #111;">
            <i class="fas fa-box" style="margin-right: 8px;"></i>PRODUCT DETAILS
        </h4>
    </div>
    
    <table class="invoice-table">
        <thead>
            <tr>
                <th width="4%">SR NO.</th>
                <th width="8%">IMAGE</th>
                <th width="20%">PRODUCT NAME</th>
                <th width="28%">PRODUCT DESCRIPTION</th>
                <th width="6%">QTY</th>
                <th width="9%">UNIT PRICE (₹)</th>
                <th width="9%">TOTAL (₹)</th>
            </tr>
        </thead>
        <tbody>
            <?php
                // Define base URL for images
                $baseUrl = url('/');
                
                $sampleItems = [
                    [
                        'product_name' => 'ECT-088B Commercial Monster Treadmill',
                        'description' => "Specification: Motor 4HP (8HP Peak) Speed - 20 km/h Elevation - 0-20% Display-21.5 inch HD Screen Running Belt - 1520*525mm Dimensions-2000*1000*550mm NW/GW - 248kg / 278kg Max User Weight - 200kg\nFeature: ECT-088 Commercial Monster Treadmill",
                        'quantity' => 2,
                        'price' => 56500.00,
                        'image' => 'treadmill.jpg'
                    ],
                    [
                        'product_name' => 'EHC-022 Home Use Cycle',
                        'description' => "Specification: Display- LCD Screen Fly Wheel-18Kg User Weight- 150Kg N.W/G.W- 35Kg/40Kg Dimension: 1010*250*890mm\nFeature: - Console- Display, Time, Speed, Distance, Calories - Brake- Friction Brake System - With Phone, Bottle Holder - Adjustable Seat - Rubber Wheel for easy Transportation - No Abrasion to the floor",
                        'quantity' => 2,
                        'price' => 8900.00,
                        'image' => 'exercise-bike.jpg'
                    ]
                ];
                
                // Use actual items if available, otherwise use sample
                $itemsToDisplay = isset($invoice->items) && count($invoice->items) > 0 ? $invoice->items : $sampleItems;
                $subtotal = 0;
            ?>
            
            <?php $__currentLoopData = $itemsToDisplay; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                // Get the correct product name from database
                $productName = '';
                
                if (is_object($item)) {
                    // If item has a product relationship
                    if (isset($item->product) && is_object($item->product)) {
                        $productName = $item->product->name ?? $item->product->product_name ?? 'N/A';
                    }
                    // If item has product_name property directly
                    elseif (isset($item->product_name)) {
                        $productName = $item->product_name;
                    }
                    // If item has name property
                    elseif (isset($item->name)) {
                        $productName = $item->name;
                    }
                    // Fallback to name from array
                    else {
                        $productName = $item['name'] ?? 'N/A';
                    }
                } else {
                    // If item is an array
                    $productName = $item['product_name'] ?? $item['name'] ?? 'N/A';
                }
                
                $itemQuantity = $item->quantity ?? $item['quantity'] ?? 0;
                $itemPrice = $item->price ?? $item['price'] ?? 0;
                $itemTotal = $itemPrice * $itemQuantity;
                $subtotal += $itemTotal;
                
                // Get description
                $description = '';
                if (is_object($item)) {
                    if (isset($item->product) && is_object($item->product)) {
                        $description = $item->product->description ?? $item->description ?? '';
                    } else {
                        $description = $item->description ?? '';
                    }
                } else {
                    $description = $item['description'] ?? '';
                }
            ?>
            <tr style="<?php echo e($loop->even ? 'background-color: #f8f9fa;' : ''); ?>">
                <td class="text-center" style="font-weight: 600;"><?php echo e($key + 1); ?></td>
                <td class="text-center">
                    <?php
                        $imageUrl = null;
                        
                        // Get image value
                        if (is_object($item)) {
                            // Try to get image from product relationship first
                            if (isset($item->product) && is_object($item->product)) {
                                $rawImage = $item->product->image ?? $item->image ?? null;
                            } else {
                                $rawImage = $item->image ?? null;
                            }
                        } else {
                            $rawImage = $item['image'] ?? null;
                        }
                        
                        if ($rawImage) {
                            // ✅ FULL URL (http / https)
                            if (Str::startsWith($rawImage, ['http://', 'https://'])) {
                                $imageUrl = str_replace(' ', '%20', $rawImage);
                            }
                            // ✅ LOCAL STORAGE IMAGE
                            else {
                                $imageUrl = asset('public/' . str_replace(' ', '%20', $rawImage));
                            }
                        }
                    ?>
                    
                    <?php if($imageUrl): ?>
                        <img
                            src="<?php echo e($imageUrl); ?>"
                            alt="<?php echo e($productName); ?>"
                            class="product-image"
                            style="width:140px;height:140px;object-fit:cover;border-radius:4px;"
                            crossorigin="anonymous"
                            onerror="this.onerror=null; this.style.display='none'; this.parentNode.innerHTML='<div class=\'image-placeholder\'><i class=\'fas fa-image\'></i><br>Product</div>';">
                    <?php else: ?>
                        <div class="image-placeholder">
                            <i class="fas fa-image"></i><br>Product
                        </div>
                    <?php endif; ?>
                </td>
                <td class="text-left">
                    <div class="product-name"><?php echo e($productName); ?></div>
                </td>
                <td class="text-left">
                    <div style="margin-top: 5px;">
                        <small style="white-space: pre-line; color: #666; line-height: 1.5;">
                            <?php echo e($description); ?>

                        </small>
                    </div>
                </td>
                <td class="text-center">
                    <span class="badge" style="background: #2c3e50;"><?php echo e($itemQuantity); ?> PCS</span>
                </td>
                <td class="text-right price-amount">₹<?php echo e(number_format($itemPrice, 2)); ?></td>
                <td class="text-right price-amount">₹<?php echo e(number_format($itemTotal, 2)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    
    <div style="clear: both; margin-top: 20px;">
        <table class="total-summary">
            <tr>
                <td width="60%"><strong>Sub Total:</strong></td>
                <td class="text-right price-amount">₹<?php echo e(number_format($subtotal, 2)); ?></td>
            </tr>
            <tr>
                <td><strong>Additional Discount:</strong></td>
                <td class="text-right price-amount">- ₹<?php echo e(number_format($invoice->discount ?? 0, 2)); ?></td>
            </tr>
            <tr>
                <td><strong>GST @ 18%:</strong></td>
                <td class="text-right price-amount">₹<?php echo e(number_format($invoice->tax ?? 23544, 2)); ?></td>
            </tr>
            <tr>
                <td class="total-amount">GRAND TOTAL:</td>
                <td class="text-right total-amount">₹<?php echo e(number_format($invoice->grand_total ?? 154344, 2)); ?></td>
            </tr>
        </table>
    </div>

    <div class="clearfix"></div>

    
    <div class="page-break"></div>

    
    <div class="three-columns">
        <!-- Bank Details Column -->
        <div class="column">
            <div class="column-title">
                <i class="fas fa-university" style="margin-right: 8px;"></i>BANK DETAILS
            </div>
            <div class="column-content">
                <div style="background: #e9f7fe; padding: 12px; border-radius: 6px; margin-bottom: 15px;">
                    <strong style="color: #2c3e50;">ACCOUNT HOLDER</strong><br>
                    <!--<strong style="font-size: 12px;">DIVINE FITNESS</strong>-->
                </div>
                <table style="width: 100%;">
                    <tr>
                        <td><strong>Account No:</strong></td>
                        <td class="text-right">257069278939</td>
                    </tr>
                    <tr>
                        <td><strong>IFSC Code:</strong></td>
                        <td class="text-right">INDB0001031</td>
                    </tr>
                    <tr>
                        <td><strong>Bank:</strong></td>
                        <td class="text-right">INDUSIND BANK</td>
                    </tr>
                    <tr>
                        <td><strong>Branch:</strong></td>
                        <td class="text-right">KALUPUR AHMEDABAD</td>
                    </tr>
                </table>
                <div style="margin-top: 15px; padding: 10px; background: #fff3cd; border-radius: 6px; font-size: 10px;">
                    <strong>⚠️ Important:</strong> Please mention Quotation Number in payment remarks.
                </div>
            </div>
        </div>
        
        <!-- Terms & Conditions Column -->
<div class="column">
    <div class="column-title">
        <i class="fas fa-file-contract" style="margin-right: 8px;"></i>TERMS & CONDITIONS
    </div>
    <div class="column-content" style="padding: 15px 0;">
        <div class="terms-list" style="text-align: justify; text-justify: inter-word;">
            <div class="term-item">
                1- GST @ 18% Included.
            </div>
            <div class="term-spacer"></div>
            
            <div class="term-item">
                2- The Rates mentioned on quotation is valid for today only
            </div>
            <div class="term-spacer"></div>
            
            <div class="term-item">
                3- DELIVERY: Within 15 to 50 Days From 'The date of full payment' or 'Delivery confirmation date from customer', whichever is later.
            </div>
            <div class="term-spacer"></div>
            
            <div class="term-item">
                4- Shipping/Transportation Charge (EXTRA)
            </div>
            <div class="term-spacer"></div>
            
            <div class="term-item">
                5- Unloading charges to be paid by customer.
            </div>
            <div class="term-spacer"></div>
            
            <div class="term-item">
                6- Installation Charges Free If value of order Exceeds Rs.5,00,000 (Only for retails)
            </div>
            <div class="term-spacer"></div>
            
            <div class="term-item">
                7- NO RETURN & NO EXCHANGE.
            </div>
            <div class="term-spacer"></div>
            
            <div class="term-item">
                8- Cancellation after paying advance payment against a quotation.
                <div class="sub-terms" style="padding-left: 25px; margin-top: 5px;">
                    A. Within 1 week of Payment –10 % Cancellation Charges would levied<br>
                    B. After 1 week of Payment till 1 month – 20% Cancellation Charges would levied<br>
                    C. After 1 month of Payment till 3 month – 50% Cancellation Charges would levied<br>
                    D. Post 3 months – NO REFUND
                </div>
            </div>
            <div class="term-spacer"></div>
            
            <div class="term-item">
                9- The Gym owner will be responsible for providing food and accommodation to the technicians who come for installation.
            </div>
            <div class="term-spacer"></div>
            
            <div class="term-item">
                10- The customer will also be responsible for removing the polythene and packing from the product.
            </div>
        </div>
    </div>
</div>        
        <!-- Warranty Policy Column -->
       <div class="column">
    <div class="column-title">
        <i class="fas fa-shield-alt" style="margin-right: 8px;"></i>WARRANTY POLICY
    </div>
    <div class="column-content">
        <div style="background: #d4edda; padding: 12px; border-radius: 6px; margin-bottom: 15px; text-align: center;">
            <strong style="color: #155724; font-size: 16px;">WARRANTY DURATION: 1 YEAR</strong>
        </div>
        
        <div style="margin-bottom: 20px; text-align: justify; text-justify: inter-word;">
            <strong style="color: #721c24; display: block; margin-bottom: 10px;">⚠️ PARTS NOT IN WARRANTY</strong>
            <div style="padding-left: 15px;">
                <div>1. All Plastic Part</div>
                <div>2. All Rubber parts (inc. Handle rubber)</div>
                <div>3. Consumable Parts</div>
                <div>4. Motor and drive (If the parts are burn or blast case)</div>
                <div>5. Motor (5 yr warranty only on AC motor if the customer is using servo)</div>
                <div>6. Paddle</div>
                <div>7. Resistance knob</div>
                <div>8. Seat</div>
            </div>
            <div style="background: #f8d7da; padding: 8px; border-radius: 4px; margin-top: 12px; font-size: 12px;">
                <strong>**Note:</strong> 5 KVA Servo Stabilizer or UPS is mandatory for Treadmills for the warranty.
            </div>
        </div>
        
        <div style="text-align: justify; text-justify: inter-word;">
            <strong style="color: #155724; display: block; margin-bottom: 10px;">✅ PART COVERED IN 1 YEAR WARRANTY</strong>
            <div style="padding-left: 15px;">
                <div>1. Axcel Rod and Shaft</div>
                <div>2. Bearing</div>
                <div>3. Belt (if it is broken from stitching then only it will comes under warranty)</div>
                <div>4. Breakshoe</div>
                <div>5. Break Patti, Break Shoe Set</div>
                <div>6. Display inner board</div>
                <div>7. Drive</div>
                <div>8. Generator</div>
                <div>9. Motor and Incline Motor</div>
                <div>10. PCB and battery box</div>
                <div>11. V belt</div>
            </div>
        </div>
    </div>
</div>
    </div>

    
    <div class="terms-section">
        <h4>
            <i class="fas fa-info-circle" style="margin-right: 8px;"></i>ADDITIONAL TERMS & CONDITIONS
        </h4>
        <div class="terms-list">
            1- PARTIAL PAYMENT:<br>
            &nbsp;&nbsp;A. If Payment less than 50% of the Quotation value then we cannot block inventory and will be subject to availability after fulfilment of point 4-B.<br>
            &nbsp;&nbsp;B. If 'Payment greater than 50% of the Quotation value' or 'Full Payment of the Quotation Value' then the inventory will be hoarded (free of cost) by the company for a duration of 3 months from the date of last payment.<br>
            &nbsp;&nbsp;&nbsp;&nbsp;*After 3 months a basic fee of 2% per month of the Quotation value will be deducted as a inventory hoarding fee. This will be adjusted in the final payment of the quotation value.<br>
            2- No warranty and guarantee will be provided on the machines without the official Divine Fitness sticker.<br>
            3- For any discrepancy, Ahmedabad jurisdiction will be applicable.
        </div>
    </div>

    
   <div class="terms-section">
    <h4>
        <i class="fas fa-cogs" style="margin-right: 8px;"></i>GYM EQUIPMENT SPECIFICATION
    </h4>
    <div class="terms-list">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 15px; margin-top: 10px;">
            <div style="background: #f8f9fa; padding: 12px; border-radius: 6px; border-left: 4px solid #ff0000;">
                <strong>1. Frame Size:</strong> 2*4 Square Pipe 2.5 Mm Thickness
            </div>
            <div style="background: #f8f9fa; padding: 12px; border-radius: 6px; border-left: 4px solid #ff0000;">
                <strong>2. Material:</strong> Crc Pipe 12 Gauge Unbreakable
            </div>
            <div style="background: #f8f9fa; padding: 12px; border-radius: 6px; border-left: 4px solid #ff0000;">
                <strong>3. Cable System:</strong> Using 5 Mm Imported and Pulleys Are of Nylon With Bearing Mounted
            </div>
            <div style="background: #f8f9fa; padding: 12px; border-radius: 6px; border-left: 4px solid #ff0000;">
                <strong>4. Finish:</strong> We Do Powder Coating in Machine
            </div>
            <div style="background: #f8f9fa; padding: 12px; border-radius: 6px; border-left: 4px solid #ff0000;">
                <strong>5. Hand Contact:</strong> All Areas Are Provided Rubber Grips
            </div>
            <div style="background: #f8f9fa; padding: 12px; border-radius: 6px; border-left: 4px solid #ff0000;">
                <strong>6. Moving Parts:</strong> All Moving Parts Are Bearing Mounted
            </div>
            <div style="background: #f8f9fa; padding: 12px; border-radius: 6px; border-left: 4px solid #ff0000;">
                <strong>7. Fasteners:</strong> Using Best Quality Alanki Nut Bolts
            </div>
            <div style="background: #f8f9fa; padding: 12px; border-radius: 6px; border-left: 4px solid #ff0000;">
                <strong>8. Seating:</strong> We Use in Seat Good Quality Regling
            </div>
            <div style="background: #f8f9fa; padding: 12px; border-radius: 6px; border-left: 4px solid #ff0000; grid-column: span 2;">
                <strong>9. Weight System:</strong> Selectorised Weights of MS Bright Iron With Nylon Bushes & 5 Kg Each
            </div>
        </div>
    </div>
</div>

    
    <div class="footer">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-top: 30px;">
            <div style="text-align: left; width: 30%;">
                <div style="border-top: 2px solid #2c3e50; padding-top: 15px; margin-top: 10px;">
                    <strong>Customer Signature</strong><br>
                    <div style="height: 50px; margin-top: 10px;"></div>
                </div>
            </div>
            <BR>
            <div style="text-align: center; width: 40%;">
                <!-- <div style="margin-bottom: 15px; color: #666;">
                    <strong>This is a computer generated quotation</strong><br>
                    Signature not required for acceptance
                </div> -->
                <div style="font-size: 17px; font-weight: bold; color: #000000; text-align: center; margin: 20px 0; padding: 10px;">
    <span style="color: #000000;">Thank you for choosing Divine Fitness Equipment</span><br>
    <span style="font-size: 14px; color: #000000; font-weight: 500;">We look forward to serving you!</span>
</div>
            </div>
            
            <div style="text-align: right; width: 30%;">
                <div style="border-top: 2px solid #2c3e50; padding-top: 15px; margin-top: 10px;">
                    <strong>For Divine Fitness</strong><br>
                    Authorized Signatory
                    <div style="height: 50px; margin-top: 10px;"></div>
                </div>
            </div>
        </div>
        
    <!--    <div style="margin-top: 25px; padding-top: 15px; border-top: 1px solid #dee2e6; font-size: 10px; color: #777;">-->
    <!--        <div style="display: flex; justify-content: space-between;">-->
    <!--            <div>-->
    <!--                <strong>Generated On:</strong> <?php echo e(date('d-M-Y h:i A')); ?>-->
    <!--            </div>-->
    <!--            <div>-->
    <!--                <strong>Quotation ID:</strong> <?php echo e($invoice->invoice_no ?? 'R-1/Q/25-26/5363'); ?>-->
    <!--            </div>-->
    <!--            <div>-->
    <!--                <strong>Page:</strong> 1 of 1-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</div>-->

</div>

<script>
// Function to download PDF
function downloadPDF() {
    const element = document.getElementById('invoice-content');
    const invoiceNo = "<?php echo e($invoice->invoice_no ?? 'R-1/Q/25-26/5363'); ?>";
    const customerName = "<?php echo e($invoice->customer_name ?? 'Divine-Fitness'); ?>";
    const fileName = `DivineFitness-Quotation-${invoiceNo}-${customerName}.pdf`;
    
    // PDF options
    const options = {
        margin: [15, 15, 15, 15],
        filename: fileName,
        image: { 
            type: 'jpeg', 
            quality: 0.98 
        },
        html2canvas: { 
            scale: 2,
            useCORS: true,
            logging: false,
            allowTaint: true,
            backgroundColor: '#FFFFFF',
            scrollY: 0
        },
        jsPDF: { 
            unit: 'mm', 
            format: 'a4', 
            orientation: 'portrait',
            compress: true
        }
    };
    
    // Show loading message
    const loadingMsg = document.createElement('div');
    loadingMsg.innerHTML = `
        <div style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); color: white; display: flex; flex-direction: column; justify-content: center; align-items: center; z-index: 9999; font-size: 18px;">
            <div style="margin-bottom: 20px; font-size: 24px;">⏳ Generating PDF...</div>
            <div>Please wait while we prepare your quotation document.</div>
        </div>
    `;
    document.body.appendChild(loadingMsg);
    
    // Generate and download PDF
    html2pdf().set(options).from(element).save().then(() => {
        document.body.removeChild(loadingMsg);
        alert('✅ Quotation PDF downloaded successfully!');
    }).catch(err => {
        document.body.removeChild(loadingMsg);
        alert('❌ Error generating PDF. Please try again or use the Print option.');
        console.error('PDF Generation Error:', err);
    });
}

// Function to print the invoice
function printInvoice() {
    window.print();
}

// Add event listeners when page loads
document.addEventListener('DOMContentLoaded', function() {
    // Make sure images are loaded properly
    const images = document.querySelectorAll('img');
    
    images.forEach(img => {
        // Add error handler
        img.onerror = function() {
            console.log('Image failed to load:', this.src);
            this.style.display = 'none';
            const placeholder = document.createElement('div');
            placeholder.className = 'image-placeholder';
            placeholder.innerHTML = '<i class="fas fa-image"></i><br>Product';
            this.parentNode.appendChild(placeholder);
        };
        
        // Add load handler for debugging
        img.onload = function() {
            console.log('Image loaded successfully:', this.src);
        };
        
        // Force load image with cache busting
        if (!img.complete && img.src) {
            img.src = img.src + (img.src.includes('?') ? '&' : '?') + 't=' + new Date().getTime();
        }
    });
    
    // Add Font Awesome icons for better UI
    if (!document.querySelector('link[href*="font-awesome"]')) {
        const link = document.createElement('link');
        link.rel = 'stylesheet';
        link.href = 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css';
        document.head.appendChild(link);
    }
    
    // Preload images for better PDF generation
    setTimeout(function() {
        console.log('All images loaded (or attempted)');
    }, 1000);
});
</script>

</body>
</html><?php /**PATH /home/jkmetal/public_html/resources/views/invoices/download.blade.php ENDPATH**/ ?>