

<?php $__env->startSection('content'); ?>
<div class="container">
    <h1>Edit Invoice</h1>
    
    <form id="invoiceForm" method="POST" action="<?php echo e(route('invoices.update', $invoice->id)); ?>">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        
        <div class="row">
            <!-- Left Column - Invoice Details -->
            <div class="col-md-6">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Invoice Details</h5>
                    </div>
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="invoice_no" class="form-label">Invoice No</label>
                                <input type="text" class="form-control" id="invoice_no" name="invoice_no" 
                                       value="<?php echo e($invoice->invoice_no); ?>" readonly>
                            </div>
                            <div class="col-md-6">
                                <label for="invoice_date" class="form-label">Invoice Date</label>
                                <input type="date" class="form-control" id="invoice_date" name="invoice_date" 
                                       value="<?php echo e($invoice->invoice_date->format('Y-m-d')); ?>" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="customer_id" class="form-label">Customer</label>
                            <select class="form-select" id="customer_id" name="customer_id" required>
                                <option value="">--SELECT CUSTOMER--</option>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($customer->id); ?>"
                                        <?php echo e($invoice->customer_id == $customer->id ? 'selected' : ''); ?>>
                                        <?php echo e($customer->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Right Column - Payment Details -->
            <div class="col-md-6">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Payment Details</h5>
                    </div>
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label">Sub Amount</label>
                                <div class="form-control" id="sub_amount_display">₹<?php echo e(number_format($invoice->sub_amount, 2)); ?></div>
                                <input type="hidden" id="sub_amount" name="sub_amount" value="<?php echo e($invoice->sub_amount); ?>">
                            </div>
                            <div class="col-md-4">
                                <label for="discount" class="form-label">Discount (₹)</label>
                                <input type="number" class="form-control" id="discount" name="discount" 
                                       value="<?php echo e($invoice->discount); ?>" min="0" step="0.01">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Total Amount</label>
                                <div class="form-control" id="total_amount_display">₹<?php echo e(number_format($invoice->total_amount, 2)); ?></div>
                                <input type="hidden" id="total_amount" name="total_amount" value="<?php echo e($invoice->total_amount); ?>">
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">GST (18%)</label>
                                <div class="form-control" id="gst_amount_display">₹<?php echo e(number_format($invoice->gst_amount, 2)); ?></div>
                                <input type="hidden" id="gst_amount" name="gst_amount" value="<?php echo e($invoice->gst_amount); ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Grand Total</label>
                                <div class="form-control fw-bold" id="grand_total_display">₹<?php echo e(number_format($invoice->grand_total, 2)); ?></div>
                                <input type="hidden" id="grand_total" name="grand_total" value="<?php echo e($invoice->grand_total); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Products Section -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Products</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table" id="products_table">
                        <thead>
                            <tr>
                                <th width="30%">Product</th>
                                <th width="20%">Price (₹)</th>
                                <th width="20%">Quantity</th>
                                <th width="20%">Total (₹)</th>
                                <th width="10%">Action</th>
                            </tr>
                        </thead>
                        <tbody id="products_tbody">
                            <?php $rowCount = 0; ?>
                            <?php $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr id="product_row_<?php echo e($rowCount + 1); ?>">
                                <td>
                                    <select class="form-select product-select" name="products[<?php echo e($rowCount); ?>][product_id]" 
                                            data-row="<?php echo e($rowCount + 1); ?>" onchange="fetchProductPrice(<?php echo e($rowCount + 1); ?>)" required>
                                        <option value="">--SELECT PRODUCT--</option>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($product->id); ?>" 
                                                    data-price="<?php echo e($product->price); ?>" 
                                                    data-quantity="<?php echo e($product->quantity); ?>"
                                                    <?php echo e($item->product_id == $product->id ? 'selected' : ''); ?>>
                                                <?php echo e($product->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <input type="hidden" name="products[<?php echo e($rowCount); ?>][id]" value="<?php echo e($item->id); ?>">
                                    <input type="hidden" name="products[<?php echo e($rowCount); ?>][product_name]" class="product-name" value="<?php echo e($item->product->name); ?>">
                                </td>
                                <td>
                                    <input type="number" class="form-control price" name="products[<?php echo e($rowCount); ?>][price]" 
                                           id="price_<?php echo e($rowCount + 1); ?>" value="<?php echo e($item->price); ?>" readonly step="0.01">
                                </td>
                                <td>
                                    <input type="number" class="form-control quantity" name="products[<?php echo e($rowCount); ?>][quantity]" 
                                           id="quantity_<?php echo e($rowCount + 1); ?>" value="<?php echo e($item->quantity); ?>" min="1" onchange="calculateRowTotal(<?php echo e($rowCount + 1); ?>)" required>
                                </td>
                                <td>
                                    <input type="number" class="form-control total" name="products[<?php echo e($rowCount); ?>][total]" 
                                           id="total_<?php echo e($rowCount + 1); ?>" value="<?php echo e($item->total); ?>" readonly step="0.01">
                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-sm" onclick="removeProductRow(<?php echo e($rowCount + 1); ?>)">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php $rowCount++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="5">
                                    <button type="button" class="btn btn-primary btn-sm" onclick="addProductRow()">
                                        <i class="fas fa-plus"></i> Add Product
                                    </button>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        
        <!-- Form Actions -->
        <div class="row">
            <div class="col-md-12 text-center">
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="fas fa-check"></i> Update Invoice
                </button>
                <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-secondary btn-lg">
                    <i class="fas fa-times"></i> Cancel
                </a>
            </div>
        </div>
    </form>
</div>

<!-- JavaScript for Dynamic Functionality -->
<script>
    let rowCount = <?php echo e($rowCount); ?>;
    
    // Add new product row
    function addProductRow() {
        rowCount++;
        const tbody = document.getElementById('products_tbody');
        const newRow = document.createElement('tr');
        newRow.id = `product_row_${rowCount}`;
        
        newRow.innerHTML = `
            <td>
                <select class="form-select product-select" name="products[${rowCount-1}][product_id]" 
                        data-row="${rowCount}" onchange="fetchProductPrice(${rowCount})" required>
                    <option value="">--SELECT PRODUCT--</option>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($product->id); ?>" 
                                data-price="<?php echo e($product->price); ?>" 
                                data-quantity="<?php echo e($product->quantity); ?>">
                            <?php echo e($product->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <input type="hidden" name="products[${rowCount-1}][product_name]" class="product-name">
            </td>
            <td>
                <input type="number" class="form-control price" name="products[${rowCount-1}][price]" 
                       id="price_${rowCount}" readonly step="0.01">
            </td>
            <td>
                <input type="number" class="form-control quantity" name="products[${rowCount-1}][quantity]" 
                       id="quantity_${rowCount}" min="1" value="1" onchange="calculateRowTotal(${rowCount})" required>
            </td>
            <td>
                <input type="number" class="form-control total" name="products[${rowCount-1}][total]" 
                       id="total_${rowCount}" readonly step="0.01">
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeProductRow(${rowCount})">
                    <i class="fas fa-trash"></i>
                </button>
            </td>
        `;
        
        tbody.appendChild(newRow);
    }
    
    // Remove product row
    function removeProductRow(rowId) {
        const row = document.getElementById(`product_row_${rowId}`);
        if (row && rowCount > 1) {
            row.remove();
            calculateInvoiceTotals();
        }
    }
    
    // Fetch product price
    function fetchProductPrice(rowId) {
        const selectElement = document.querySelector(`#product_row_${rowId} .product-select`);
        const selectedOption = selectElement.options[selectElement.selectedIndex];
        const priceInput = document.getElementById(`price_${rowId}`);
        const productNameInput = document.querySelector(`#product_row_${rowId} .product-name`);
        
        if (selectedOption.value) {
            const price = selectedOption.getAttribute('data-price');
            const productName = selectedOption.text;
            
            priceInput.value = price;
            productNameInput.value = productName;
            
            // Calculate row total
            calculateRowTotal(rowId);
        } else {
            priceInput.value = '';
            productNameInput.value = '';
            document.getElementById(`total_${rowId}`).value = '';
        }
    }
    
    // Calculate row total
    function calculateRowTotal(rowId) {
        const priceInput = document.getElementById(`price_${rowId}`);
        const quantityInput = document.getElementById(`quantity_${rowId}`);
        const totalInput = document.getElementById(`total_${rowId}`);
        
        const price = parseFloat(priceInput.value) || 0;
        const quantity = parseInt(quantityInput.value) || 0;
        
        const total = price * quantity;
        totalInput.value = total.toFixed(2);
        
        calculateInvoiceTotals();
    }
    
    // Calculate all invoice totals
    function calculateInvoiceTotals() {
        let subTotal = 0;
        const totalInputs = document.querySelectorAll('.total');
        
        totalInputs.forEach(input => {
            const value = parseFloat(input.value) || 0;
            subTotal += value;
        });
        
        const discount = parseFloat(document.getElementById('discount').value) || 0;
        const totalAmount = subTotal;
        const gstAmount = (totalAmount - discount) * 0.18;
        const grandTotal = (totalAmount - discount) + gstAmount;
        
        // Update display fields
        document.getElementById('sub_amount_display').textContent = '₹' + subTotal.toFixed(2);
        document.getElementById('sub_amount').value = subTotal.toFixed(2);
        
        document.getElementById('total_amount_display').textContent = '₹' + totalAmount.toFixed(2);
        document.getElementById('total_amount').value = totalAmount.toFixed(2);
        
        document.getElementById('gst_amount_display').textContent = '₹' + gstAmount.toFixed(2);
        document.getElementById('gst_amount').value = gstAmount.toFixed(2);
        
        document.getElementById('grand_total_display').textContent = '₹' + grandTotal.toFixed(2);
        document.getElementById('grand_total').value = grandTotal.toFixed(2);
    }
    
    // Initialize calculations
    document.addEventListener('DOMContentLoaded', function() {
        // Add event listener for discount
        document.getElementById('discount').addEventListener('input', calculateInvoiceTotals);
        
        // Add event listeners for existing rows
        for (let i = 1; i <= rowCount; i++) {
            const selectElement = document.querySelector(`#product_row_${i} .product-select`);
            const quantityElement = document.getElementById(`quantity_${i}`);
            
            if (selectElement) {
                selectElement.addEventListener('change', () => fetchProductPrice(i));
            }
            
            if (quantityElement) {
                quantityElement.addEventListener('input', () => calculateRowTotal(i));
            }
        }
    });
</script>

<style>
    .card {
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        border: 1px solid #dee2e6;
    }
    
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #dee2e6;
    }
    
    .form-control:read-only {
        background-color: #f8f9fa;
    }
    
    #grand_total_display {
        background-color: #f0f9ff;
        font-size: 1.1rem;
    }
    
    .table th {
        background-color: #f8f9fa;
        font-weight: 600;
    }
    
    .btn-lg {
        min-width: 150px;
        margin: 0 10px;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\invoice-system\resources\views/invoices/edit.blade.php ENDPATH**/ ?>