<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $__env->yieldContent('title', 'Invoice System'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: #f4f6f9;
            min-height: 100vh;
        }

        /* Sidebar */
        .sidebar {
            width: 240px;
            height: 100vh;
            background: #4f46e5;
            color: #fff;
            position: fixed;
            top: 0;
            left: 0;
            padding-top: 20px;
            transition: all 0.3s;
        }

        .sidebar a {
            display: block;
            color: #fff;
            padding: 14px 20px;
            text-decoration: none;
            font-weight: 500;
            border-radius: 8px;
            margin: 4px 10px;
        }

        .sidebar a:hover {
            background: #4338ca;
        }

        .sidebar .sidebar-brand {
            font-size: 24px;
            font-weight: 700;
            text-align: center;
            margin-bottom: 30px;
        }

        /* Main content */
        .main-content {
            margin-left: 240px;
            padding: 30px;
            transition: all 0.3s;
        }

        /* Responsive */
        @media(max-width: 768px) {
            .sidebar {
                width: 100%;
                height: auto;
                position: relative;
            }
            .main-content {
                margin-left: 0;
            }
        }

        /* Card tweaks */
        .card {
            border-radius: 12px;
        }

        .btn-primary {
            background-color: #4f46e5;
            border: none;
        }

        .btn-primary:hover {
            background-color: #4338ca;
        }
    </style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar">
    <div class="sidebar-brand mb-4">Invoice System</div>
    <a href="<?php echo e(route('dashboard')); ?>"><i class="fa fa-home me-2"></i> Dashboard</a>
    <a href="<?php echo e(route('customers.index')); ?>"><i class="fa fa-users me-2"></i> Customers</a>
    <a href="<?php echo e(route('products.index')); ?>"><i class="fa fa-box me-2"></i> Products</a>
     <a href="<?php echo e(route('categories.index')); ?>"><i class="fa fa-box me-2"></i> Category</a>
    <a href="<?php echo e(route('invoices.index')); ?>"><i class="fa fa-file-invoice me-2"></i> Invoices</a>
<!-- <a href="<?php echo e(route('quotation.index')); ?>">
    <i class="fa fa-receipt me-2"></i> Quotation
</a> -->

    <form method="POST" action="<?php echo e(route('logout')); ?>">
        <?php echo csrf_field(); ?>
        <button class="btn btn-danger w-100 mt-4"><i class="fa fa-sign-out-alt me-2"></i> Logout</button>
    </form>
</div>

<!-- Main content -->
<div class="main-content">
    <?php echo $__env->yieldContent('content'); ?>
</div>

<!-- Bootstrap JS Bundle (optional for responsive behaviors) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\invoice-system\resources\views/layouts/app.blade.php ENDPATH**/ ?>