<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $__env->yieldContent('title', 'Invoice System'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            height: 100vh;
            overflow: hidden;
        }

        .auth-container {
            display: flex;
            height: 100vh;
        }

        /* LEFT SIDE PANEL */
        .left-panel {
            flex: 1;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: #fff;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 60px;
        }

        .left-panel h1 {
            font-size: 36px;
            font-weight: 700;
        }

        .left-panel p {
            font-size: 18px;
            margin-top: 15px;
            line-height: 1.5;
            text-align: center;
            max-width: 300px;
            opacity: 0.9;
        }

        /* RIGHT FORM PANEL */
        .right-panel {
            flex: 1;
            display: flex;
            justify-content: center;
            align-items: center;
            background: #f4f6f9;
            padding: 40px;
        }

        .auth-card {
            width: 100%;
            max-width: 400px;
            background: #fff;
            border-radius: 15px;
            padding: 40px 30px;
            box-shadow: 0 15px 40px rgba(0,0,0,0.2);
        }

        .auth-title {
            font-weight: 700;
            font-size: 26px;
            margin-bottom: 25px;
            text-align: center;
            color: #333;
        }

        .form-control {
            border-radius: 8px;
            padding: 10px 15px;
        }

        .btn-primary {
            border-radius: 8px;
            background: #667eea;
            border: none;
            font-weight: 500;
            padding: 10px;
        }

        .btn-primary:hover {
            background: #5a67d8;
        }

        .auth-footer {
            margin-top: 20px;
            text-align: center;
            font-size: 14px;
        }

        .auth-footer a {
            color: #764ba2;
            font-weight: 500;
            text-decoration: none;
        }

        @media(max-width: 768px) {
            .auth-container {
                flex-direction: column;
            }
            .left-panel {
                display: none;
            }
            .right-panel {
                flex: none;
                height: 100vh;
            }
        }
    </style>
</head>
<body>

<div class="auth-container">

    <!-- LEFT PANEL -->
    <div class="left-panel">
        <h1>Invoice System</h1>
        <p>Manage your invoices, products, and customers efficiently. Fast • Secure • Modern</p>
        <!-- Optional illustration -->
        <img src="https://cdn-icons-png.flaticon.com/512/3135/3135715.png" alt="Invoice Illustration" style="width:200px;margin-top:30px;">
    </div>

    <!-- RIGHT PANEL -->
    <div class="right-panel">
        <div class="auth-card">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>

</div>

</body>
</html>
<?php /**PATH /home/jkmetal/public_html/resources/views/layouts/auth.blade.php ENDPATH**/ ?>