

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <!-- Header Card -->
            <div class="card shadow-sm mb-4 border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-2">
                                    <li class="breadcrumb-item active" aria-current="page">Invoices</li>
                                </ol>
                            </nav>
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-size: 20px;">
                                    <i class="fas fa-file-invoice"></i>
                                </div>
                                <div>
                                    <h1 class="h3 fw-bold mb-0">Invoice Management</h1>
                                    <p class="text-muted mb-0">Manage all your invoices in one place</p>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <a href="<?php echo e(route('invoices.create')); ?>" class="btn btn-success px-4">
                                <i class="fas fa-plus-circle me-1"></i>Create Invoice
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Card -->
            <div class="card shadow border-0">
                <div class="card-header bg-white py-3">
                    <h5 class="mb-0 fw-semibold">
                        <i class="fas fa-list text-primary me-2"></i>
                        Invoice List
                    </h5>
                </div>
                
                <div class="card-body p-0">
                    <?php if($invoices->isEmpty()): ?>
                        <div class="text-center py-5">
                            <i class="fas fa-file-invoice fa-4x text-muted mb-3"></i>
                            <h4 class="text-muted">No invoices found</h4>
                            <p class="text-muted">Create your first invoice to get started</p>
                            <a href="<?php echo e(route('invoices.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i>Create Invoice
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="fw-semibold">ID</th>
                                        <th class="fw-semibold">Invoice No</th>
                                        <th class="fw-semibold">Customer</th>
                                        <th class="fw-semibold">Date</th>
                                        <th class="fw-semibold">Total Amount</th>
                                        <th class="fw-semibold text-center">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="align-middle">
                                        <td>
                                            <span class="text-muted"><?php echo e($loop->iteration); ?></span>
                                        </td>
                                        <td>
                                            <strong><?php echo e($invoice->invoice_no ?? '—'); ?></strong>
                                        </td>
                                        <td>
                                            <?php echo e($invoice->customer->name ?? 'N/A'); ?>

                                        </td>
                                        <td>
                                            <?php echo e($invoice->invoice_date); ?>

                                        </td>
                                        <td>
                                            <strong class="text-success">₹ <?php echo e(number_format($invoice->grand_total, 2)); ?></strong>
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <a href="<?php echo e(route('invoices.show', $invoice->id)); ?>"
                                                   class="btn btn-sm btn-outline-info">
                                                    View
                                                </a>

                                                <a href="<?php echo e(route('invoices.download', $invoice->id)); ?>"
                                                   class="btn btn-sm btn-outline-success">
                                                    Download
                                                </a>

                                                <form action="<?php echo e(route('invoices.destroy', $invoice->id)); ?>"
                                                      method="POST"
                                                      class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-danger delete-btn"
                                                            data-invoice-no="<?php echo e($invoice->invoice_no ?? 'this invoice'); ?>">
                                                        Delete
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Card Footer -->
                <div class="card-footer bg-light py-3">
                    <div class="row align-items-center">
                        <div class="col-md-12 text-center">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Showing <?php echo e($invoices->count()); ?> invoices
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Delete confirmation
    document.querySelectorAll('.delete-btn').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const invoiceNo = this.dataset.invoiceNo;
            const form = this.closest('form');
            
            if (confirm('Are you sure you want to delete ' + invoiceNo + '?')) {
                form.submit();
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .avatar-circle {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }

    .card {
        border: none;
        border-radius: 15px;
        overflow: hidden;
    }

    .card-header {
        background-color: white;
        border-bottom: 1px solid rgba(0,0,0,.125);
        font-weight: 600;
    }

    .table {
        margin-bottom: 0;
    }

    .table thead th {
        border-bottom: 2px solid #dee2e6;
        font-weight: 600;
        color: #495057;
        padding: 1rem;
    }

    .table tbody tr {
        transition: background-color 0.2s;
    }

    .table tbody tr:hover {
        background-color: rgba(13, 110, 253, 0.05);
    }

    .table tbody td {
        padding: 1rem;
        vertical-align: middle;
    }

    .btn-outline-info,
    .btn-outline-success,
    .btn-outline-danger {
        border-width: 1px;
        padding: 0.25rem 0.75rem;
        font-size: 0.875rem;
    }

    .btn-outline-info:hover,
    .btn-outline-success:hover,
    .btn-outline-danger:hover {
        transform: translateY(-1px);
    }

    .btn-success {
        background: linear-gradient(135deg, #198754 0%, #157347 100%);
        border: none;
        padding: 0.5rem 1.5rem;
        font-weight: 500;
    }

    .btn-success:hover {
        background: linear-gradient(135deg, #157347 0%, #0d5c3a 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2);
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin-bottom: 0.5rem;
    }

    .breadcrumb-item.active {
        color: #495057;
        font-weight: 500;
    }

    .card-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\invoice-system\resources\views/invoices/index.blade.php ENDPATH**/ ?>