<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\InvoiceItemController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\QuotationController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application.
|
*/

Route::get('/', function () {
    return view('welcome');
});

// ----------------------
// login Routes
// ----------------------
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
Route::get('/logout', [AuthController::class, 'logout'])->name('logout');


Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'register'])->name('register.submit');



   // Dashboard route
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    Route::resource('invoices', InvoiceController::class);
Route::get('invoices/{invoice}/download', [InvoiceController::class, 'download'])
    ->name('invoices.download');
    

    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
Route::resource('categories', CategoryController::class); // name: categories.index
Route::post('/categories/delete-multiple', [CategoryController::class, 'deleteMultiple'])
    ->name('categories.delete-multiple');


    Route::resource('quotation', QuotationController::class);

// ----------------------
// Customer Routes
// ----------------------
Route::resource('customers', CustomerController::class);

// ----------------------
// Product Routes
// ----------------------
Route::resource('products', ProductController::class);

// ----------------------
// Invoice Routes
// ----------------------
Route::resource('invoices', InvoiceController::class);

// ----------------------
// Invoice Items Routes
// Nested under invoices
// ----------------------
Route::prefix('invoices/{invoiceId}/items')->group(function() {
    Route::get('/', [InvoiceItemController::class, 'index'])->name('invoice_items.index');
    Route::get('/create', [InvoiceItemController::class, 'create'])->name('invoice_items.create');
    Route::post('/', [InvoiceItemController::class, 'store'])->name('invoice_items.store');
    Route::get('/{id}/edit', [InvoiceItemController::class, 'edit'])->name('invoice_items.edit');
    Route::put('/{id}', [InvoiceItemController::class, 'update'])->name('invoice_items.update');
    Route::delete('/{id}', [InvoiceItemController::class, 'destroy'])->name('invoice_items.destroy');
});
