@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <!-- Header Card -->
            <div class="card shadow-sm mb-4 border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-2">
                                    <li class="breadcrumb-item active" aria-current="page">Quotations</li>
                                </ol>
                            </nav>
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-size: 20px;">
                                    <i class="fas fa-file-invoice-dollar"></i>
                                </div>
                                <div>
                                    <h1 class="h3 fw-bold mb-0">Quotation Management</h1>
                                    <p class="text-muted mb-0">Manage all your quotations in one place</p>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <a href="{{ route('quotation.create') }}" class="btn btn-success px-4">
                                <i class="fas fa-plus-circle me-1"></i>Create New Quotation
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Card -->
            <div class="card shadow border-0">
                <div class="card-header bg-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 fw-semibold">
                            <i class="fas fa-list text-primary me-2"></i>
                            Quotation List
                        </h5>
                        <div class="d-flex align-items-center gap-2">
                            <input type="text" id="searchInput" class="form-control form-control-sm" placeholder="Search quotations..." style="width: 200px;">
                            <select id="statusFilter" class="form-select form-select-sm" style="width: 150px;">
                                <option value="">All Status</option>
                                <option value="draft">Draft</option>
                                <option value="sent">Sent</option>
                                <option value="approved">Approved</option>
                                <option value="rejected">Rejected</option>
                                <option value="expired">Expired</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="card-body p-0">
                    @if($quotations->isEmpty())
                        <div class="text-center py-5">
                            <i class="fas fa-file-invoice-dollar fa-4x text-muted mb-3"></i>
                            <h4 class="text-muted">No quotations found</h4>
                            <p class="text-muted">Create your first quotation to get started</p>
                            <a href="{{ route('quotation.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i>Create Quotation
                            </a>
                        </div>
                    @else
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="fw-semibold">Quotation No</th>
                                        <th class="fw-semibold">Customer</th>
                                        <th class="fw-semibold">Date</th>
                                        <th class="fw-semibold">Valid Till</th>
                                        <th class="fw-semibold text-end">Amount</th>
                                        <th class="fw-semibold">Status</th>
                                        <th class="fw-semibold text-center">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($quotations as $quotation)
                                    <tr class="align-middle">
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="me-3">
                                                    <div class="avatar-circle bg-light text-primary d-flex align-items-center justify-content-center" 
                                                         style="width: 40px; height: 40px; font-size: 14px;">
                                                        <i class="fas fa-file-invoice"></i>
                                                    </div>
                                                </div>
                                                <div>
                                                    <strong class="d-block">{{ $quotation->quotation_no }}</strong>
                                                    <small class="text-muted d-block">
                                                        Created: {{ $quotation->created_at->format('d-M-Y') }}
                                                    </small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <strong class="d-block">{{ $quotation->customer->name }}</strong>
                                                @if($quotation->customer->phone)
                                                    <small class="text-muted d-block">
                                                        <i class="fas fa-phone me-1"></i>{{ $quotation->customer->phone }}
                                                    </small>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            <span class="text-muted">
                                                {{ \Carbon\Carbon::parse($quotation->quotation_date)->format('d-M-Y') }}
                                            </span>
                                        </td>
                                        <td>
                                            <span class="text-muted">
                                                {{ \Carbon\Carbon::parse($quotation->valid_till)->format('d-M-Y') }}
                                                @if(\Carbon\Carbon::now()->gt($quotation->valid_till) && $quotation->status != 'expired')
                                                    <br><small class="text-danger">(Expired)</small>
                                                @endif
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <div>
                                                <strong class="text-success">₹{{ number_format($quotation->grand_total, 2) }}</strong>
                                                @if($quotation->discount > 0)
                                                    <br><small class="text-muted">
                                                        <s>₹{{ number_format($quotation->sub_amount, 2) }}</s>
                                                        <span class="text-danger">-₹{{ number_format($quotation->discount, 2) }}</span>
                                                    </small>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            @php
                                                $statusColors = [
                                                    'draft' => 'secondary',
                                                    'sent' => 'info',
                                                    'approved' => 'success',
                                                    'rejected' => 'danger',
                                                    'expired' => 'warning'
                                                ];
                                                $color = $statusColors[$quotation->status] ?? 'secondary';
                                            @endphp
                                            <span class="badge bg-{{ $color }} px-2 py-1">
                                                <i class="fas fa-circle fa-xs me-1"></i>
                                                {{ ucfirst($quotation->status) }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <a href="{{ route('quotation.show', $quotation->id) }}" 
                                                   class="btn btn-sm btn-outline-info" 
                                                   title="View"
                                                   data-bs-toggle="tooltip">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('quotation.edit', $quotation->id) }}" 
                                                   class="btn btn-sm btn-outline-warning" 
                                                   title="Edit"
                                                   data-bs-toggle="tooltip">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <a href="{{ route('quotation.print', $quotation->id) }}" 
                                                   class="btn btn-sm btn-outline-primary" 
                                                   title="Print"
                                                   data-bs-toggle="tooltip"
                                                   target="_blank">
                                                    <i class="fas fa-print"></i>
                                                </a>
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-danger delete-btn"
                                                        title="Delete"
                                                        data-bs-toggle="tooltip"
                                                        data-id="{{ $quotation->id }}"
                                                        data-no="{{ $quotation->quotation_no }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>

                @if($quotations->isNotEmpty())
                <div class="card-footer bg-light py-3">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Showing {{ $quotations->firstItem() }} to {{ $quotations->lastItem() }} of {{ $quotations->total() }} quotations
                            </small>
                        </div>
                        <div class="col-md-6 text-end">
                            {{ $quotations->links() }}
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    Confirm Deletion
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete quotation <strong id="quotationNoText"></strong>?</p>
                <p class="text-danger mb-0">
                    <small>
                        <i class="fas fa-exclamation-circle me-1"></i>
                        This action cannot be undone. All associated items will also be deleted.
                    </small>
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    @csrf 
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete Quotation</button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Initialize tooltips
    document.addEventListener('DOMContentLoaded', function() {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        // Delete confirmation
        const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
        const deleteForm = document.getElementById('deleteForm');
        const quotationNoText = document.getElementById('quotationNoText');

        document.querySelectorAll('.delete-btn').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const id = this.dataset.id;
                const quotationNo = this.dataset.no;
                
                // Set modal content
                quotationNoText.textContent = quotationNo;
                
                // Set form action
                deleteForm.action = "{{ route('quotation.destroy', '') }}/" + id;
                
                // Show modal
                deleteModal.show();
            });
        });

        // Search functionality
        const searchInput = document.getElementById('searchInput');
        const statusFilter = document.getElementById('statusFilter');
        
        function filterTable() {
            const searchTerm = searchInput.value.toLowerCase();
            const statusValue = statusFilter.value;
            
            document.querySelectorAll('tbody tr').forEach(row => {
                const quotationNo = row.querySelector('td:nth-child(1) strong').textContent.toLowerCase();
                const customerName = row.querySelector('td:nth-child(2) strong').textContent.toLowerCase();
                const statusBadge = row.querySelector('td:nth-child(6) .badge').textContent.toLowerCase();
                
                const matchesSearch = quotationNo.includes(searchTerm) || customerName.includes(searchTerm);
                const matchesStatus = !statusValue || statusBadge.includes(statusValue);
                
                row.style.display = (matchesSearch && matchesStatus) ? '' : 'none';
            });
        }
        
        searchInput.addEventListener('input', filterTable);
        statusFilter.addEventListener('change', filterTable);
        
        // Reset filters button (optional)
        const resetFilters = document.createElement('button');
        resetFilters.className = 'btn btn-sm btn-outline-secondary';
        resetFilters.innerHTML = '<i class="fas fa-redo me-1"></i>Reset';
        resetFilters.addEventListener('click', function() {
            searchInput.value = '';
            statusFilter.value = '';
            filterTable();
        });
        
        // Add reset button to filter area
        document.querySelector('.card-header .d-flex').appendChild(resetFilters);
    });
</script>
@endpush

@push('styles')
<style>
    .avatar-circle {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }

    .card {
        border: none;
        border-radius: 15px;
        overflow: hidden;
    }

    .card-header {
        background-color: white;
        border-bottom: 1px solid rgba(0,0,0,.125);
        font-weight: 600;
    }

    .table {
        margin-bottom: 0;
    }

    .table thead th {
        border-bottom: 2px solid #dee2e6;
        font-weight: 600;
        color: #495057;
        padding: 1rem;
        white-space: nowrap;
    }

    .table tbody tr {
        transition: background-color 0.2s;
    }

    .table tbody tr:hover {
        background-color: rgba(13, 110, 253, 0.05);
    }

    .table tbody td {
        padding: 1rem;
        vertical-align: middle;
    }

    .badge {
        font-weight: 500;
        padding: 0.4rem 0.75rem;
        border-radius: 20px;
        font-size: 0.85rem;
        letter-spacing: 0.5px;
    }

    .btn-outline-info,
    .btn-outline-warning,
    .btn-outline-primary,
    .btn-outline-danger {
        border-width: 1px;
        padding: 0.25rem 0.5rem;
        width: 32px;
        height: 32px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    .btn-outline-info:hover,
    .btn-outline-warning:hover,
    .btn-outline-primary:hover,
    .btn-outline-danger:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .btn-success {
        background: linear-gradient(135deg, #198754 0%, #157347 100%);
        border: none;
        padding: 0.5rem 1.5rem;
        font-weight: 500;
    }

    .btn-success:hover {
        background: linear-gradient(135deg, #157347 0%, #0d5c3a 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2);
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin-bottom: 0.5rem;
    }

    .breadcrumb-item.active {
        color: #495057;
        font-weight: 500;
    }

    .card-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
    }

    /* Status badge specific colors */
    .bg-draft {
        background-color: #6c757d !important;
        color: white !important;
    }

    .bg-sent {
        background-color: #0dcaf0 !important;
        color: white !important;
    }

    .bg-approved {
        background-color: #198754 !important;
        color: white !important;
    }

    .bg-rejected {
        background-color: #dc3545 !important;
        color: white !important;
    }

    .bg-expired {
        background-color: #ffc107 !important;
        color: #212529 !important;
    }

    /* Filter controls */
    #searchInput, #statusFilter {
        border-radius: 20px;
        font-size: 0.875rem;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .table-responsive {
            font-size: 0.85rem;
        }
        
        .btn-sm {
            padding: 0.2rem 0.4rem;
            font-size: 0.75rem;
        }
        
        .card-header .d-flex {
            flex-direction: column;
            gap: 10px !important;
            align-items: flex-start !important;
        }
        
        #searchInput, #statusFilter {
            width: 100% !important;
        }
    }
</style>
@endpush
@endsection