<!-- In your edit.blade.php -->
<form method="POST" action="{{ route('quotation.update', $quotation->id) }}" id="updateQuotationForm">
    @csrf
    @method('PUT')

    <!-- Customer Information -->
    <div class="mb-3">
        <label for="customer_id" class="form-label fw-semibold">
            Customer <span class="text-danger">*</span>
        </label>
        <select name="customer_id" 
                id="customer_id"
                class="form-select @error('customer_id') is-invalid @enderror" 
                required>
            <option value="">Select Customer</option>
            @foreach($customers as $customer)
                <option value="{{ $customer->id }}" 
                    {{ old('customer_id', $quotation->customer_id) == $customer->id ? 'selected' : '' }}>
                    {{ $customer->name }} 
                    @if($customer->phone)
                        ({{ $customer->phone }})
                    @endif
                </option>
            @endforeach
        </select>
    </div>

    <!-- Quotation Details -->
    <div class="mb-3">
        <label for="quotation_no" class="form-label fw-semibold">
            Quotation Number
        </label>
        <input type="text" 
               name="quotation_no" 
               id="quotation_no"
               value="{{ old('quotation_no', $quotation->quotation_no) }}"
               class="form-control" 
               readonly>
    </div>

    <div class="mb-3">
        <label for="quotation_date" class="form-label fw-semibold">
            Quotation Date <span class="text-danger">*</span>
        </label>
        <input type="date" 
               name="quotation_date" 
               id="quotation_date"
               value="{{ old('quotation_date', $quotation->quotation_date->format('Y-m-d')) }}"
               class="form-control" 
               required>
    </div>

    <div class="mb-3">
        <label for="valid_till" class="form-label fw-semibold">
            Valid Till <span class="text-danger">*</span>
        </label>
        <input type="date" 
               name="valid_till" 
               id="valid_till"
               value="{{ old('valid_till', $quotation->valid_till->format('Y-m-d')) }}"
               class="form-control" 
               required>
    </div>

    <!-- Products Section -->
    <div class="table-responsive">
        <table class="table table-bordered" id="products_table">
            <thead class="table-light">
                <tr>
                    <th width="40%">Product <span class="text-danger">*</span></th>
                    <th width="15%">Quantity <span class="text-danger">*</span></th>
                    <th width="15%">Price (₹) <span class="text-danger">*</span></th>
                    <th width="15%">Subtotal (₹)</th>
                    <th width="15%">Actions</th>
                </tr>
            </thead>
            <tbody id="products_tbody">
                @foreach($productsData as $key => $product)
                    <tr id="product_row_{{ $key + 1 }}">
                        <td>
                            <select class="form-select product-select" 
                                    name="products[{{ $key }}][product_id]" 
                                    data-row="{{ $key + 1 }}" required>
                                <option value="">Select Product</option>
                                @foreach($products as $prod)
                                    <option value="{{ $prod->id }}" 
                                            data-price="{{ $prod->price }}" 
                                            data-stock="{{ $prod->quantity }}"
                                            {{ $product['product_id'] == $prod->id ? 'selected' : '' }}>
                                        {{ $prod->name }}
                                        @if($prod->sku)
                                            ({{ $prod->sku }})
                                        @endif
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td>
                            <input type="number" 
                                   class="form-control quantity" 
                                   name="products[{{ $key }}][quantity]" 
                                   id="quantity_{{ $key + 1 }}" 
                                   min="1" 
                                   value="{{ $product['quantity'] }}" 
                                   required>
                        </td>
                        <td>
                            <input type="number" 
                                   class="form-control price" 
                                   name="products[{{ $key }}][price]" 
                                   id="price_{{ $key + 1 }}" 
                                   step="0.01" 
                                   min="0" 
                                   value="{{ $product['price'] }}" 
                                   required>
                        </td>
                        <td>
                            <input type="number" 
                                   class="form-control subtotal" 
                                   name="products[{{ $key }}][subtotal]" 
                                   id="subtotal_{{ $key + 1 }}" 
                                   step="0.01" 
                                   min="0" 
                                   value="{{ $product['subtotal'] }}" 
                                   readonly>
                        </td>
                        <td class="text-center">
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeProductRow({{ $key + 1 }})">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="5">
                        <button type="button" class="btn btn-primary btn-sm" onclick="addProductRow()">
                            <i class="fas fa-plus"></i> Add Product
                        </button>
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>

    <!-- Notes -->
    <div class="mb-3">
        <label for="notes" class="form-label fw-semibold">
            Notes / Terms & Conditions
        </label>
        <textarea name="notes" 
                id="notes" 
                class="form-control" 
                rows="4">{{ old('notes', $quotation->notes) }}</textarea>
    </div>

    <!-- Status -->
    <div class="mb-3">
        <label for="status" class="form-label fw-semibold">
            Status
        </label>
        <select name="status" 
                id="status"
                class="form-select">
            <option value="draft" {{ old('status', $quotation->status) == 'draft' ? 'selected' : '' }}>Draft</option>
            <option value="sent" {{ old('status', $quotation->status) == 'sent' ? 'selected' : '' }}>Sent</option>
            <option value="accepted" {{ old('status', $quotation->status) == 'accepted' ? 'selected' : '' }}>Accepted</option>
            <option value="rejected" {{ old('status', $quotation->status) == 'rejected' ? 'selected' : '' }}>Rejected</option>
            <option value="expired" {{ old('status', $quotation->status) == 'expired' ? 'selected' : '' }}>Expired</option>
        </select>
    </div>

    <!-- Summary Section -->
    <div class="row mb-4">
        <div class="col-md-4 offset-md-8">
            <div class="form-section">
                <h6 class="section-title">
                    <i class="fas fa-calculator me-2"></i>Amount Summary
                </h6>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-2">
                        <span class="text-muted">Sub Amount:</span>
                        <span class="fw-semibold" id="sub_amount_display">₹{{ number_format($quotation->sub_amount, 2) }}</span>
                        <input type="hidden" name="sub_amount" id="sub_amount" value="{{ $quotation->sub_amount }}">
                    </div>
                    
                    <div class="d-flex justify-content-between mb-2">
                        <span class="text-muted">Discount:</span>
                        <div class="input-group input-group-sm" style="width: 120px;">
                            <input type="number" 
                                   name="discount" 
                                   id="discount"
                                   value="{{ old('discount', $quotation->discount) }}"
                                   class="form-control form-control-sm" 
                                   step="0.01"
                                   min="0">
                            <span class="input-group-text">₹</span>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-between mb-2">
                        <span class="text-muted">GST (18%):</span>
                        <span class="fw-semibold text-warning" id="gst_amount_display">₹{{ number_format($quotation->gst_amount, 2) }}</span>
                        <input type="hidden" name="gst_amount" id="gst_amount" value="{{ $quotation->gst_amount }}">
                    </div>
                    
                    <hr>
                    
                    <div class="d-flex justify-content-between mb-2">
                        <span class="fw-bold">Grand Total:</span>
                        <span class="fw-bold text-success fs-5" id="grand_total_display">₹{{ number_format($quotation->grand_total, 2) }}</span>
                        <input type="hidden" name="grand_total" id="grand_total" value="{{ $quotation->grand_total }}">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Form Actions -->
    <div class="d-flex justify-content-between align-items-center pt-4 border-top">
        <div>
            <a href="{{ route('quotation.index') }}" 
               class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-1"></i>Back to Quotations
            </a>
        </div>
        <div>
            <button type="submit" class="btn btn-success px-4">
                <i class="fas fa-save me-1"></i>Update Quotation
            </button>
        </div>
    </div>
</form>

<script>
    // Initialize with existing data
    document.addEventListener('DOMContentLoaded', function() {
        // Set rowCount based on existing products
        rowCount = {{ count($productsData) }};
        
        // Setup event listeners for all existing rows
        for (let i = 1; i <= rowCount; i++) {
            setupRowEventListeners(i);
        }
        
        // Add event listener for discount
        document.getElementById('discount').addEventListener('input', calculateTotals);
        
        // Calculate initial totals
        calculateTotals();
    });
</script>