@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <!-- Header Card -->
            <div class="card shadow-sm mb-4 border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <div>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-2">
                                    <li class="breadcrumb-item"><a href="{{ route('customers.index') }}" class="text-decoration-none">Customers</a></li>
                                    <li class="breadcrumb-item"><a href="{{ route('customers.show', $customer->id) }}" class="text-decoration-none">{{ $customer->name }}</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Edit</li>
                                </ol>
                            </nav>
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-size: 20px;">
                                    {{ strtoupper(substr($customer->name, 0, 1)) }}
                                </div>
                                <div>
                                    <h1 class="h3 fw-bold mb-0">Edit Customer</h1>
                                    <p class="text-muted mb-0">ID: {{ str_pad($customer->id, 6, '0', STR_PAD_LEFT) }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <span class="badge bg-light text-dark fs-6 p-2">
                                <i class="fas fa-calendar-alt me-1"></i>
                                Created: {{ $customer->created_at->format('M d, Y') }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Form Card -->
            <div class="card shadow border-0">
                <div class="card-header bg-white py-3">
                    <h5 class="mb-0 fw-semibold">
                        <i class="fas fa-edit text-primary me-2"></i>
                        Customer Information
                    </h5>
                </div>
                
                <div class="card-body p-4">
                    @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <div class="d-flex">
                                <i class="fas fa-exclamation-triangle me-3 mt-1"></i>
                                <div>
                                    <h6 class="alert-heading mb-2">Please fix the following errors:</h6>
                                    <ul class="mb-0 ps-3">
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('customers.update', $customer->id) }}" id="editCustomerForm">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <!-- Personal Information Section -->
                            <div class="col-md-6 mb-4">
                                <div class="form-section">
                                    <h6 class="section-title">
                                        <i class="fas fa-user-circle me-2"></i>Personal Information
                                    </h6>
                                    
                                    <div class="mb-3">
                                        <label for="name" class="form-label fw-semibold">
                                            Full Name <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light">
                                                <i class="fas fa-user text-primary"></i>
                                            </span>
                                            <input type="text" 
                                                   name="name" 
                                                   id="name"
                                                   value="{{ old('name', $customer->name) }}"
                                                   class="form-control @error('name') is-invalid @enderror" 
                                                   required
                                                   placeholder="Enter customer full name">
                                            @error('name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="email" class="form-label fw-semibold">
                                            Email Address <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light">
                                                <i class="fas fa-envelope text-primary"></i>
                                            </span>
                                            <input type="email" 
                                                   name="email" 
                                                   id="email"
                                                   value="{{ old('email', $customer->email) }}"
                                                   class="form-control @error('email') is-invalid @enderror" 
                                                   required
                                                   placeholder="customer@example.com">
                                            @error('email')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Contact Information Section -->
                            <div class="col-md-6 mb-4">
                                <div class="form-section">
                                    <h6 class="section-title">
                                        <i class="fas fa-address-book me-2"></i>Contact Information
                                    </h6>
                                    
                                    <div class="mb-3">
                                        <label for="phone" class="form-label fw-semibold">
                                            Phone Number
                                        </label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light">
                                                <i class="fas fa-phone text-primary"></i>
                                            </span>
                                            <input type="text" 
                                                   name="phone" 
                                                   id="phone"
                                                   value="{{ old('phone', $customer->phone) }}"
                                                   class="form-control @error('phone') is-invalid @enderror" 
                                                   placeholder="(123) 456-7890">
                                            @error('phone')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="address" class="form-label fw-semibold">
                                            Address
                                        </label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light align-items-start pt-3">
                                                <i class="fas fa-map-marker-alt text-primary"></i>
                                            </span>
                                            <textarea name="address" 
                                                      id="address"
                                                      class="form-control @error('address') is-invalid @enderror" 
                                                      rows="4"
                                                      placeholder="Enter complete address">{{ old('address', $customer->address) }}</textarea>
                                            @error('address')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <small class="text-muted">Enter street, city, state, and ZIP code</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Additional Notes Section -->
                        <!-- <div class="row mb-4">
                            <div class="col-12">
                                <div class="form-section">
                                    <h6 class="section-title">
                                        <i class="fas fa-sticky-note me-2"></i>Additional Information
                                    </h6>
                                    <div class="mb-3">
                                        <label for="notes" class="form-label fw-semibold">
                                            Notes (Optional)
                                        </label>
                                        <textarea name="notes" 
                                                  id="notes"
                                                  class="form-control" 
                                                  rows="3"
                                                  placeholder="Add any additional notes or comments about this customer">{{ old('notes', $customer->notes ?? '') }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div> -->

                        <!-- Form Actions -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center pt-4 border-top">
                                    <div>
                                        <!-- <a href="{{ route('customers.show', $customer->id) }}" 
                                           class="btn btn-outline-secondary me-2">
                                            <i class="fas fa-eye me-1"></i>View
                                        </a> -->
                                        <a href="{{ route('customers.index') }}" 
                                           class="btn btn-outline-secondary">
                                            <i class="fas fa-arrow-left me-1"></i>Back to List
                                        </a>
                                    </div>
                                    <div>
                                        <button type="reset" class="btn btn-outline-danger me-2">
                                            <i class="fas fa-redo me-1"></i>Reset
                                        </button>
                                        <button type="submit" class="btn btn-success px-4">
                                            <i class="fas fa-save me-1"></i>Update Customer
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- Card Footer -->
                <div class="card-footer bg-light py-3">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Last updated: {{ $customer->updated_at->diffForHumans() }}
                            </small>
                        </div>
                        <div class="col-md-6 text-end">
                            <form action="{{ route('customers.destroy', $customer->id) }}" 
                                  method="POST" 
                                  class="d-inline"
                                  id="deleteForm">
                                @csrf
                                @method('DELETE')
                                <button type="button" 
                                        class="btn btn-sm btn-outline-danger" 
                                        id="deleteCustomerBtn"
                                        data-customer-name="{{ $customer->name }}">
                                    <i class="fas fa-trash me-1"></i>Delete Customer
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Form validation
    document.getElementById('editCustomerForm').addEventListener('submit', function(e) {
        const requiredFields = this.querySelectorAll('[required]');
        let valid = true;
        
        requiredFields.forEach(field => {
            if (!field.value.trim()) {
                valid = false;
                if (!field.classList.contains('is-invalid')) {
                    field.classList.add('is-invalid');
                    field.nextElementSibling?.classList?.remove('d-none');
                }
            }
        });
        
        if (!valid) {
            e.preventDefault();
            const alertDiv = document.createElement('div');
            alertDiv.className = 'alert alert-danger alert-dismissible fade show mt-3';
            alertDiv.innerHTML = `
                <i class="fas fa-exclamation-triangle me-2"></i>
                Please fill in all required fields.
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            this.querySelector('.card-body').prepend(alertDiv);
        }
    });

    // Remove validation styling on input
    document.querySelectorAll('input, textarea').forEach(field => {
        field.addEventListener('input', function() {
            if (this.classList.contains('is-invalid')) {
                this.classList.remove('is-invalid');
            }
        });
    });

    // Phone number formatting
    document.getElementById('phone').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 3 && value.length <= 6) {
            value = `(${value.slice(0,3)}) ${value.slice(3)}`;
        } else if (value.length > 6) {
            value = `(${value.slice(0,3)}) ${value.slice(3,6)}-${value.slice(6,10)}`;
        }
        e.target.value = value;
    });

    // Delete confirmation
    document.getElementById('deleteCustomerBtn').addEventListener('click', function() {
        const customerName = this.dataset.customerName;
        
        Swal.fire({
            title: 'Are you sure?',
            text: `You are about to delete "${customerName}". This action cannot be undone!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel',
            reverseButtons: true,
            customClass: {
                confirmButton: 'btn btn-danger',
                cancelButton: 'btn btn-secondary'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('deleteForm').submit();
            }
        });
    });

    // Character counter for notes
    const notesTextarea = document.getElementById('notes');
    if (notesTextarea) {
        const counter = document.createElement('small');
        counter.className = 'text-muted float-end';
        counter.textContent = `${notesTextarea.value.length}/500`;
        
        notesTextarea.parentNode.appendChild(counter);
        
        notesTextarea.addEventListener('input', function() {
            counter.textContent = `${this.value.length}/500`;
            
            if (this.value.length > 500) {
                counter.classList.remove('text-muted');
                counter.classList.add('text-danger');
            } else {
                counter.classList.remove('text-danger');
                counter.classList.add('text-muted');
            }
        });
    }

    // Form reset confirmation
    document.querySelector('button[type="reset"]').addEventListener('click', function(e) {
        if (document.getElementById('editCustomerForm').checkValidity()) {
            Swal.fire({
                title: 'Reset Form?',
                text: 'All changes will be lost. Are you sure you want to reset?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Yes, reset',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (!result.isConfirmed) {
                    e.preventDefault();
                }
            });
        }
    });
</script>
@endpush

@push('styles')
<style>
    .avatar-circle {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }

    .form-section {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 1.5rem;
        margin-bottom: 1.5rem;
        border: 1px solid #e9ecef;
    }

    .section-title {
        color: #495057;
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 1.5rem;
        padding-bottom: 0.5rem;
        border-bottom: 2px solid #dee2e6;
    }

    .form-label {
        font-weight: 500;
        margin-bottom: 0.5rem;
        color: #495057;
    }

    .input-group-text {
        border-right: none;
        background-color: #f8f9fa !important;
    }

    .form-control {
        border-left: none;
        padding-left: 0;
    }

    .form-control:focus {
        box-shadow: none;
        border-color: #86b7fe;
    }

    .form-control:focus + .input-group-text {
        border-color: #86b7fe;
    }

    .card {
        border: none;
        border-radius: 15px;
        overflow: hidden;
    }

    .card-header {
        background-color: white;
        border-bottom: 1px solid rgba(0,0,0,.125);
        font-weight: 600;
    }

    .alert {
        border: none;
        border-radius: 10px;
    }

    .alert-danger {
        background-color: #f8d7da;
        border-left: 4px solid #dc3545;
    }

    .alert-success {
        background-color: #d1e7dd;
        border-left: 4px solid #198754;
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin-bottom: 0.5rem;
    }

    .breadcrumb-item a {
        color: #6c757d;
        transition: color 0.2s;
    }

    .breadcrumb-item a:hover {
        color: #0d6efd;
        text-decoration: underline;
    }

    .btn-success {
        background: linear-gradient(135deg, #198754 0%, #157347 100%);
        border: none;
        padding: 0.5rem 2rem;
        font-weight: 500;
    }

    .btn-success:hover {
        background: linear-gradient(135deg, #157347 0%, #0d5c3a 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2);
    }

    .btn-outline-secondary:hover {
        transform: translateY(-1px);
    }

    .btn-outline-danger:hover {
        background-color: #dc3545;
        color: white;
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .badge {
        font-weight: 500;
        padding: 0.5rem 1rem;
        border-radius: 20px;
    }

    .card-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
    }
</style>
@endpush
@endsection