@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Header Card -->
            <div class="card shadow-sm mb-4 border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <div>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-2">
                                    <li class="breadcrumb-item"><a href="{{ route('categories.index') }}" class="text-decoration-none">Categories</a></li>
                                    <li class="breadcrumb-item"><a href="{{ route('categories.show', $category) }}" class="text-decoration-none">{{ $category->name }}</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Edit</li>
                                </ol>
                            </nav>
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-warning text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-size: 20px;">
                                    <i class="fas fa-edit"></i>
                                </div>
                                <div>
                                    <h1 class="h3 fw-bold mb-0">Edit Category</h1>
                                    <p class="text-muted mb-0">Update category information and settings</p>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <span class="badge bg-light text-dark fs-6 p-2">
                                <i class="fas fa-info-circle me-1"></i>
                                Required fields marked with *
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Form Card -->
            <div class="card shadow border-0">
                <div class="card-header bg-white py-3">
                    <h5 class="mb-0 fw-semibold">
                        <i class="fas fa-folder text-primary me-2"></i>
                        Edit Category Information
                    </h5>
                </div>
                
                <div class="card-body p-4">
                    @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <div class="d-flex">
                                <i class="fas fa-exclamation-triangle me-3 mt-1"></i>
                                <div>
                                    <h6 class="alert-heading mb-2">Please fix the following errors:</h6>
                                    <ul class="mb-0 ps-3">
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('categories.update', $category) }}" id="editCategoryForm">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <!-- Basic Information Section -->
                            <div class="col-md-12 mb-4">
                                <div class="form-section">
                                    <h6 class="section-title">
                                        <i class="fas fa-info-circle me-2"></i>Basic Information
                                    </h6>
                                    
                                    <div class="mb-4">
                                        <label for="name" class="form-label fw-semibold">
                                            Category Name <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light">
                                                <i class="fas fa-folder text-primary"></i>
                                            </span>
                                            <input type="text" 
                                                   name="name" 
                                                   id="name"
                                                   value="{{ old('name', $category->name) }}"
                                                   class="form-control @error('name') is-invalid @enderror" 
                                                   required
                                                   placeholder="Enter category name">
                                            @error('name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <small class="text-muted">Choose a unique and descriptive name for the category</small>
                                    </div>

                                    <div class="mb-3">
                                        <label for="description" class="form-label fw-semibold">
                                            Description
                                        </label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light align-items-start pt-3">
                                                <i class="fas fa-align-left text-primary"></i>
                                            </span>
                                            <textarea name="description" 
                                                      id="description"
                                                      class="form-control @error('description') is-invalid @enderror" 
                                                      rows="5"
                                                      placeholder="Enter category description">{{ old('description', $category->description) }}</textarea>
                                            @error('description')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="d-flex justify-content-between mt-1">
                                            <small class="text-muted">Describe what products belong to this category</small>
                                            <small class="text-muted" id="charCount">{{ strlen(old('description', $category->description)) }}/500 characters</small>
                                        </div>
                                    </div>

                                    <!-- <div class="mb-3">
                                        <label for="status" class="form-label fw-semibold">
                                            Status
                                        </label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light">
                                                <i class="fas fa-toggle-on text-primary"></i>
                                            </span>
                                            <select name="status" 
                                                    id="status"
                                                    class="form-control @error('status') is-invalid @enderror">
                                                <option value="active" {{ old('status', $category->status) == 'active' ? 'selected' : '' }}>Active</option>
                                                <option value="inactive" {{ old('status', $category->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                            </select>
                                            @error('status')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <small class="text-muted">Active categories will be visible to customers</small>
                                    </div>
                                </div> -->
                            </div>
                        </div>

                        <!-- Category Details -->
                        <!-- <div class="row mb-4">
                            <div class="col-12">
                                <div class="form-section">
                                    <h6 class="section-title">
                                        <i class="fas fa-chart-bar me-2"></i>Category Details
                                    </h6>
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <div class="card border-0 bg-light">
                                                <div class="card-body text-center">
                                                    <div class="avatar-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; font-size: 24px;">
                                                        <i class="fas fa-hashtag"></i>
                                                    </div>
                                                    <h4 class="fw-bold mb-1">#{{ $category->id }}</h4>
                                                    <p class="text-muted mb-0">Category ID</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="card border-0 bg-light">
                                                <div class="card-body text-center">
                                                    <div class="avatar-circle bg-success text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; font-size: 24px;">
                                                        <i class="fas fa-calendar-alt"></i>
                                                    </div>
                                                    <h4 class="fw-bold mb-1">{{ $category->created_at->format('M d, Y') }}</h4>
                                                    <p class="text-muted mb-0">Created Date</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="card border-0 bg-light">
                                                <div class="card-body text-center">
                                                    <div class="avatar-circle bg-info text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; font-size: 24px;">
                                                        <i class="fas fa-clock"></i>
                                                    </div>
                                                    <h4 class="fw-bold mb-1">{{ $category->updated_at->diffForHumans() }}</h4>
                                                    <p class="text-muted mb-0">Last Updated</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> -->

                        <!-- Form Actions -->
                        <div class="row">
                            <div class="col-12">
                                <!-- <div class="d-flex justify-content-between align-items-center pt-4 border-top"> -->
                                    <div>
                                        <!-- <a href="{{ route('categories.index') }}" 
                                           class="btn btn-outline-secondary me-2">
                                            <i class="fas fa-arrow-left me-1"></i>Back to Categories
                                        </a> -->
                                        <!-- <a href="{{ route('categories.show', $category) }}" 
                                           class="btn btn-outline-primary">
                                            <i class="fas fa-eye me-1"></i>View Category
                                        </a> -->
                                    </div>
                                    <div>
                                        <button type="reset" class="btn btn-outline-danger me-2">
                                            <i class="fas fa-undo me-1"></i>Reset Changes
                                        </button>
                                        <button type="submit" class="btn btn-warning px-4">
                                            <i class="fas fa-save me-1"></i>Update Category
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- <div class="card-footer bg-light py-3"> -->
                    <div class="row align-items-center">
                        <!-- <div class="col-md-6">
                            <small class="text-muted">
                                <i class="fas fa-exclamation-triangle me-1"></i>
                                Changes will affect all products in this category
                            </small>
                        </div> -->
                        <div class="col-md-6 text-end">
                            <form action="{{ route('categories.destroy', $category) }}" method="POST" class="d-inline" onsubmit="return confirmDelete()">
                                @csrf
                                @method('DELETE')
                                <!-- <button type="submit" class="btn btn-outline-danger btn-sm">
                                    <i class="fas fa-trash me-1"></i>Delete Category
                                </button> -->
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Character counter for description
    const descriptionTextarea = document.getElementById('description');
    const charCount = document.getElementById('charCount');
    
    if (descriptionTextarea && charCount) {
        descriptionTextarea.addEventListener('input', function() {
            const length = this.value.length;
            charCount.textContent = `${length}/500 characters`;
            
            if (length > 500) {
                charCount.classList.remove('text-muted');
                charCount.classList.add('text-danger');
                this.classList.add('is-invalid');
            } else {
                charCount.classList.remove('text-danger');
                charCount.classList.add('text-muted');
                this.classList.remove('is-invalid');
            }
        });
    }

    // Form validation
    document.getElementById('editCategoryForm').addEventListener('submit', function(e) {
        const nameField = document.getElementById('name');
        let valid = true;
        
        if (!nameField.value.trim()) {
            valid = false;
            if (!nameField.classList.contains('is-invalid')) {
                nameField.classList.add('is-invalid');
            }
        }
        
        if (!valid) {
            e.preventDefault();
            const alertDiv = document.createElement('div');
            alertDiv.className = 'alert alert-danger alert-dismissible fade show mt-3';
            alertDiv.innerHTML = `
                <i class="fas fa-exclamation-triangle me-2"></i>
                Please fix the errors in the form before submitting.
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            this.querySelector('.card-body').prepend(alertDiv);
            
            nameField.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }
    });

    // Confirm delete
    function confirmDelete() {
        return confirm('Are you sure you want to delete this category? This action cannot be undone.');
    }

    // Reset confirmation
    document.querySelector('button[type="reset"]').addEventListener('click', function(e) {
        if (!confirm('Are you sure you want to reset all changes?')) {
            e.preventDefault();
        }
    });
</script>
@endpush

@push('styles')
<style>
    .avatar-circle {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }

    .form-section {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 1.5rem;
        margin-bottom: 1.5rem;
        border: 1px solid #e9ecef;
    }

    .section-title {
        color: #495057;
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 1.5rem;
        padding-bottom: 0.5rem;
        border-bottom: 2px solid #dee2e6;
    }

    .form-label {
        font-weight: 500;
        margin-bottom: 0.5rem;
        color: #495057;
    }

    .input-group-text {
        border-right: none;
        background-color: #f8f9fa !important;
    }

    .form-control, .form-select {
        border-left: none;
        padding-left: 0;
    }

    .form-control:focus, .form-select:focus {
        box-shadow: none;
        border-color: #86b7fe;
    }

    .form-control:focus + .input-group-text,
    .form-select:focus + .input-group-text {
        border-color: #86b7fe;
    }

    .card {
        border: none;
        border-radius: 15px;
        overflow: hidden;
    }

    .card-header {
        background-color: white;
        border-bottom: 1px solid rgba(0,0,0,.125);
        font-weight: 600;
    }

    .alert {
        border: none;
        border-radius: 10px;
    }

    .alert-danger {
        background-color: #f8d7da;
        border-left: 4px solid #dc3545;
    }

    .breadcrumb {
        background: transparent;
        padding: 0;
        margin-bottom: 0.5rem;
    }

    .breadcrumb-item a {
        color: #6c757d;
        transition: color 0.2s;
    }

    .breadcrumb-item a:hover {
        color: #0d6efd;
        text-decoration: underline;
    }

    .btn-warning {
        background: linear-gradient(135deg, #ffc107 0%, #e0a800 100%);
        border: none;
        padding: 0.5rem 2rem;
        font-weight: 500;
        color: #000;
    }

    .btn-warning:hover {
        background: linear-gradient(135deg, #e0a800 0%, #c69500 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(255, 193, 7, 0.2);
        color: #000;
    }

    .btn-outline-secondary:hover {
        transform: translateY(-1px);
    }

    .btn-outline-danger:hover {
        background-color: #dc3545;
        color: white;
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .badge {
        font-weight: 500;
        padding: 0.5rem 1rem;
        border-radius: 20px;
    }

    .card-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #e9ecef;
    }

    .bg-light {
        background-color: #f8f9fa !important;
    }
</style>
@endpush
@endsection