@extends('layouts.auth')

@section('title', 'Login')

@section('content')
<h4 class="mb-4 text-center fw-bold">Welcome Back</h4>

@if(session('error'))
    <div class="alert alert-danger text-center">
        {{ session('error') }}
    </div>
@endif

@if(session('success'))
    <div class="alert alert-success text-center">
        {{ session('success') }}
    </div>
@endif

<form method="POST" action="{{ route('login.submit') }}">
    @csrf

    <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" placeholder="admin@gmail.com" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Password</label>
        <input type="password" name="password" class="form-control" placeholder="********" required>
    </div>

    <button class="btn btn-primary w-100 mt-2">Login</button>

    <div class="text-center mt-3">
        <small>
            Don’t have an account?
            <a href="{{ route('register') }}">Register</a>
        </small>
    </div>
</form>
@endsection
