<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    // Fillable fields
    protected $fillable = [
        'name',
        'description',
        'sku',
        'category_id',
        'price',
        'quantity',
        'unit',
        'status',
        'image',
    ];

    /**
     * Get the category that owns the product.
     */
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    /**
     * Get the formatted price.
     */
    public function getFormattedPriceAttribute()
    {
        return '$' . number_format($this->price, 2);
    }

    /**
     * Check if product is in stock.
     */
    public function getIsInStockAttribute()
    {
        return $this->quantity > 0;
    }

    /**
     * Check if product is low stock.
     */
    public function getIsLowStockAttribute()
    {
        return $this->quantity > 0 && $this->quantity <= 10;
    }

    /**
     * Get stock status.
     */
    public function getStockStatusAttribute()
    {
        if ($this->quantity == 0) {
            return 'out_of_stock';
        } elseif ($this->quantity <= 10) {
            return 'low_stock';
        } else {
            return 'in_stock';
        }
    }
}