<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_no',
        'customer_id',
        'invoice_date',
        'sub_amount',
        'discount',
        'total_amount',
        'gst_amount',
        'grand_total',
        'paid_amount',
        'due_amount',
        'payment_type',
        'payment_status',
        'payment_place',
    ];

    protected $casts = [
        'invoice_date' => 'date',
        'sub_amount' => 'decimal:2',
        'discount' => 'decimal:2',
        'total_amount' => 'decimal:2',
        'gst_amount' => 'decimal:2',
        'grand_total' => 'decimal:2',
        'paid_amount' => 'decimal:2',
        'due_amount' => 'decimal:2',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function items()
    {
        return $this->hasMany(InvoiceItem::class);
    }
    public function invoiceItems()
{
    return $this->hasMany(InvoiceItem::class);
}

}