<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    // Fillable fields
    protected $fillable = ['name', 'description'];

    /**
     * Get the products for the category.
     */
    public function products()
    {
        return $this->hasMany(Product::class);
    }

    /**
     * Get the count of products in this category.
     */
    public function getProductsCountAttribute()
    {
        return $this->products()->count();
    }

    /**
     * Get active products for the category.
     */
    public function activeProducts()
    {
        return $this->products()->where('status', 'active');
    }

    /**
     * Get inactive products for the category.
     */
    public function inactiveProducts()
    {
        return $this->products()->where('status', 'inactive');
    }
}